/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsnx.dc.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.api.BankReceiptBatchPrintImpl;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.Lzw;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RECEIPT_FETCHLIST";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().transDate(transDate).accNo(accNo).build();
        BankReceiptBatchPrintImpl bankReceiptBatchPrint = new BankReceiptBatchPrintImpl();
        BankReceiptResponseEB receiptResponseEB = bankReceiptBatchPrint.doBiz(receiptRequest);
        List detailInfoList = (List)receiptResponseEB.getData();
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DetailInfo detailInfo : detailInfoList) {
            String fileContext = detailInfo.getExplanation();
            String json = detailInfo.getJson();
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            String hostFlowNo = jsonObject.getString("orgref");
            String amount = jsonObject.getString("tran_amt");
            String cdFlag = jsonObject.getString("itmdir");
            String oppAccNo = jsonObject.getString("rcveac");
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            StringBuilder fileName = new StringBuilder();
            fileName.append(accNo).append("_");
            fileName.append(transDateStr).append("_");
            fileName.append(hostFlowNo).append("_");
            fileName.append(amount).append("_");
            fileName.append(oppAccNo).append("_");
            fileName.append(cdFlag);
            String filePre = fileName.toString();
            if (countMap.containsKey(filePre)) {
                int serial = (Integer)countMap.get(filePre) + 1;
                countMap.put(filePre, serial);
                fileName.append("_").append(String.format("%04d", serial));
            } else {
                countMap.put(filePre, 0);
            }
            fileName.append(".pdf");
            String receiptName = fileName.toString();
            try {
                fileContext = new String(Base64.getDecoder().decode(fileContext), "ISO-8859-1");
                String expend = new Lzw(2, fileContext).expand();
                byte[] decode = Base64.getDecoder().decode(expend.getBytes());
                File receiptFile = FileCommonUtils.getFileByPath((String)bakFilePath, (String)receiptName);
                FileOutputStream out = new FileOutputStream(receiptFile);
                Throwable throwable = null;
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(decode);
                    Throwable throwable2 = null;
                    try {
                        byte[] buffer = new byte[1024];
                        int byteread = 0;
                        while ((byteread = in.read(buffer)) != -1) {
                            out.write(buffer, 0, byteread);
                        }
                        out.flush();
                        downloadListDetail.setReceiptJson(json);
                        downloadListDetail.setFileName(receiptName);
                        downloadListDetail.setFileLink(receiptName);
                        result.add(downloadListDetail);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (Throwable e) {
                logger.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }
}

