/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.receipt.common.cache.CUSMetaDataCache;
import kd.ebg.receipt.common.framework.properties.BankPropertyConfig;
import kd.ebg.receipt.common.framework.properties.PropertyConfigItem;
import kd.sdk.ebg.cus.api.ISDKBankBusiness;
import kd.sdk.ebg.cus.bean.SDKBankConfigBean;
import kd.sdk.ebg.cus.bean.SDKMultiLangBean;

public class BankBusinessConfig
extends BankPropertyConfig {
    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List list = this.getBankAddtionalPropertyConfigItems();
        ISDKBankBusiness bankBusiness = this.getBankSDKBusinessConfig();
        if (bankBusiness != null) {
            list.addAll(this.parse(bankBusiness));
        }
        return list;
    }

    private ISDKBankBusiness getBankSDKBusinessConfig() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null) {
            String bankVersionID = ebContext.getBankVersionID();
            ISDKBankBusiness bankBusiness = CUSMetaDataCache.getInstance().getCUSBankBusiness(bankVersionID);
            return bankBusiness;
        }
        return null;
    }

    private List<PropertyConfigItem> parse(ISDKBankBusiness bankBusiness) {
        ArrayList<PropertyConfigItem> result = new ArrayList<PropertyConfigItem>(1);
        List businessConfigBeanList = bankBusiness.getBankBusinessConfigBean();
        if (businessConfigBeanList != null) {
            for (SDKBankConfigBean bean : businessConfigBeanList) {
                result.add(this.getPropertyConfigItem(bean));
            }
        }
        return result;
    }

    private PropertyConfigItem getPropertyConfigItem(SDKBankConfigBean bean) {
        PropertyConfigItem item = PropertyConfigItem.builder().key(bean.getKey()).build();
        item.setMlName(this.getMultiLangEnumBridge(bean.getName()));
        item.setMlDesc(this.getMultiLangEnumBridges(bean.getDesc()));
        item.setMlSourceNames(this.getMultiLangEnumBridges(bean.getSourceNames()));
        item.setSourceValues(bean.getSourceValues());
        ArrayList<String> defaultValues = new ArrayList<String>(1);
        defaultValues.add(bean.getDefaultValue());
        item.setDefaultValues(defaultValues);
        item.setAccNo(bean.isAccNo());
        item.setType(bean.getType());
        item.setInputType(bean.getInputType().getInputType());
        return item;
    }

    private List<MultiLangEnumBridge> getMultiLangEnumBridges(List<SDKMultiLangBean> multiLangBeanList) {
        if (multiLangBeanList == null) {
            return null;
        }
        ArrayList<MultiLangEnumBridge> list = new ArrayList<MultiLangEnumBridge>(1);
        for (SDKMultiLangBean multiLangBean : multiLangBeanList) {
            list.add(this.getMultiLangEnumBridge(multiLangBean));
        }
        return list;
    }

    private List<MultiLangEnumBridge> getMultiLangEnumBridges(SDKMultiLangBean multiLangBean) {
        if (multiLangBean == null) {
            return null;
        }
        ArrayList<MultiLangEnumBridge> list = new ArrayList<MultiLangEnumBridge>(1);
        list.add(this.getMultiLangEnumBridge(multiLangBean));
        return list;
    }

    private MultiLangEnumBridge getMultiLangEnumBridge(SDKMultiLangBean multiLangBean) {
        if (multiLangBean == null) {
            return null;
        }
        return new MultiLangEnumBridge(multiLangBean.getDescription(), multiLangBean.getResourceID(), multiLangBean.getSystemType());
    }

    public String getBankVersionID() {
        return "CUS";
    }
}

