/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus.other;

import com.jcraft.jsch.ChannelSftp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.model.detail.DetailInfoOnReceipt;
import kd.ebg.egf.common.utils.FetchDataUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cus.service.util.CusBeanUtils;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.sdk.ebg.cus.api.ISDKFetchReceiptData;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKReceiptDetail;
import kd.sdk.ebg.cus.bean.biz.detail.SDKDetailInfo;

public class FetchDataImpl
implements ISDKFetchReceiptData {
    public String getReceiptFileStoragePath(String accNo, LocalDate transDate) {
        String bankVersion = EBContext.getContext().getBankVersionID();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        return FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersion, (String)accNo, (String)transDateStr);
    }

    public List<SDKReceiptDetail> getReceiptDetailById(long taskId) {
        ArrayList<SDKReceiptDetail> sdkReceiptDetails = new ArrayList<SDKReceiptDetail>(1);
        DownloadListDetailService downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        List downloadListDetails = downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            SDKReceiptDetail sdkReceiptDetail = new SDKReceiptDetail();
            sdkReceiptDetail.setFileLink(downloadListDetail.getFileLink());
            sdkReceiptDetail.setFileName(downloadListDetail.getFileName());
            sdkReceiptDetails.add(sdkReceiptDetail);
        }
        return sdkReceiptDetails;
    }

    public boolean downloadFileByPathAndName(String parentPath, String fileName, String savePath) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        if (Objects.equals(bankFtpProperties.getReceiptAchieveWay(), "bank_login")) {
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil("", null);
            return bankReceiptApiUtil.downloadReceiptFileWithPath(parentPath, fileName, savePath);
        }
        ChannelSftp sftp = null;
        try {
            sftp = SFTPUtils.getInstance().getSftp();
            boolean bl = SFTPUtils.getInstance().downloadSingleFile(parentPath, fileName, savePath, sftp);
            return bl;
        }
        catch (Throwable e) {
            throw new ReceiptException(e);
        }
        finally {
            SFTPUtils.getInstance().close(sftp);
        }
    }

    public List<SDKDetailInfo> getTransDetail(String accNo, LocalDate transDate, String bankCurrency) {
        String bankVersion = EBContext.getContext().getBankVersionID();
        String bankLogin = EBContext.getContext().getBankLoginID();
        List detailInfoOnReceipts = FetchDataUtils.queryDetailFromReceipt((String)bankVersion, (String)bankLogin, (String)accNo, (LocalDate)transDate, (String)bankCurrency);
        ArrayList<SDKDetailInfo> detailInfos = new ArrayList<SDKDetailInfo>(1);
        for (DetailInfoOnReceipt detailInfoOnReceipt : detailInfoOnReceipts) {
            SDKDetailInfo sdkDetailInfo = new SDKDetailInfo();
            CusBeanUtils.copyProperties(detailInfoOnReceipt, sdkDetailInfo);
            detailInfos.add(sdkDetailInfo);
        }
        return detailInfos;
    }
}

