/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus.service.receipt;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.receipt.banks.cus.service.util.CusBeanUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.common.cache.CUSMetaDataCache;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.sdk.ebg.cus.api.ISDKBankReceiptMetaData;
import kd.sdk.ebg.cus.bean.bank.SDKBankHeader;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKBankReceiptHandleRequest;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKBankReceiptHandleResponse;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKReceiptDetail;

public class CommonReceiptImpl
extends AbstractBankReceiptHandleImpl {
    protected SDKBankReceiptHandleRequest transFormat(BankReceiptHandleRequest bankReceiptHandleRequest) {
        SDKBankReceiptHandleRequest request = new SDKBankReceiptHandleRequest();
        SDKBankHeader sdkBankHeader = CusBeanUtils.transFormatHeader(bankReceiptHandleRequest.getHeader());
        request.setHeader(sdkBankHeader);
        CusBeanUtils.copyProperties(bankReceiptHandleRequest, request);
        return request;
    }

    private ISDKBankReceiptMetaData getBankSDKMetaData() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null) {
            String bankVersionID = ebContext.getBankVersionID();
            ISDKBankReceiptMetaData bankMetaData = CUSMetaDataCache.getInstance().getCUSMetaDataImpl(bankVersionID);
            return bankMetaData;
        }
        return null;
    }

    protected BankReceiptHandleResponseEB transFormat(SDKBankReceiptHandleResponse sdkBankReceiptHandleResponse, BankHeader header) {
        BankReceiptHandleResponseEB response = new BankReceiptHandleResponseEB();
        response.setHeader(header);
        response.setExtData(sdkBankReceiptHandleResponse.getExtData());
        List result = sdkBankReceiptHandleResponse.getResult();
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(1);
        for (SDKReceiptDetail sdkReceiptDetail : result) {
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            CusBeanUtils.copyProperties(sdkReceiptDetail, downloadListDetail);
            String receiptJson = sdkReceiptDetail.getReceiptJson();
            if (EBGStringUtils.isNotEmpty((String)receiptJson)) {
                downloadListDetail.setReceiptJson(receiptJson);
            }
            downloadListDetails.add(downloadListDetail);
        }
        response.setData(downloadListDetails);
        return response;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

