/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus.service.receipt.api;

import java.util.Map;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.cus.service.util.CusBeanUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.sdk.ebg.cus.api.biz.ISDKReceiptApiService;
import kd.sdk.ebg.cus.bean.bank.SDKBankHeader;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKBankReceiptRequest;

public class ReceiptApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private ISDKReceiptApiService isdkReceiptApiService;

    public ReceiptApiImpl(ISDKReceiptApiService isdkReceiptApiService) {
        this.isdkReceiptApiService = isdkReceiptApiService;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public SDKBankReceiptRequest transFormat(BankReceiptRequest bankReceiptRequest) {
        SDKBankReceiptRequest request = new SDKBankReceiptRequest();
        SDKBankHeader sdkBankHeader = CusBeanUtils.transFormatHeader(bankReceiptRequest.getHeader());
        request.setHeader(sdkBankHeader);
        CusBeanUtils.copyProperties(bankReceiptRequest, request);
        return request;
    }

    public BankReceiptRequest transFormatSDKBankReceiptRequest(SDKBankReceiptRequest sdkBankReceiptRequest) {
        BankReceiptRequest request = new BankReceiptRequest();
        BankHeader sdkBankHeader = CusBeanUtils.transFormatSDKHeader(sdkBankReceiptRequest.getHeader());
        request.setHeader(sdkBankHeader);
        CusBeanUtils.copyProperties(sdkBankReceiptRequest, request);
        return request;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String bankRequestStr = this.isdkReceiptApiService.pack(this.transFormat(bankReceiptRequest));
        return bankRequestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String bankResponseStr) {
        SDKBankReceiptRequest sdkBankReceiptRequest = this.transFormat(bankReceiptRequest);
        return BankReceiptResponseEB.success((Object)this.isdkReceiptApiService.parse(sdkBankReceiptRequest, bankResponseStr));
    }

    public BankReceiptResponseEB doBiz(BankReceiptRequest request) {
        if (this.isdkReceiptApiService.isBankSDK()) {
            String bankRequestStr = this.pack(request);
            String bankResponseStr = this.isdkReceiptApiService.sendAndReceive(bankRequestStr);
            return this.parse(request, bankResponseStr);
        }
        return super.doBiz(request);
    }

    public void configFactory(ConnectionFactory factory) {
        Map httpHeaderMap;
        String uri = this.isdkReceiptApiService.getHttpUri();
        if (StringUtils.isNotEmpty((String)uri)) {
            factory.setUri(uri);
        }
        if ((httpHeaderMap = this.isdkReceiptApiService.getHttpHeader()) != null) {
            for (Map.Entry entry : httpHeaderMap.entrySet()) {
                factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

