/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus.service.receipt.download;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.banks.cus.service.receipt.CommonReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.ReflectUtil;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.sdk.ebg.cus.api.biz.receipt.ISDKDownloadReceiptHandle;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKBankReceiptHandleResponse;
import kd.sdk.ebg.cus.bean.bank.receipt.SDKReceiptDetail;
import kd.sdk.ebg.cus.util.SDKFetchDataUtil;

public class ReceiptDownloadImpl
extends CommonReceiptImpl
implements IBankReceiptHandle {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadImpl.class);
    private static Map<String, ISDKDownloadReceiptHandle> cacheMap = Maps.newHashMapWithExpectedSize((int)1);

    private ISDKDownloadReceiptHandle getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        return this.getImplFromCache(bankVersionID);
    }

    private synchronized ISDKDownloadReceiptHandle getImplFromCache(String bankVersionID) {
        Set clzImplSet;
        if (!cacheMap.containsKey(bankVersionID) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKDownloadReceiptHandle.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKDownloadReceiptHandle instance = (ISDKDownloadReceiptHandle)c.newInstance();
                    cacheMap.put(instance.getBankVersionID(), instance);
                }
                catch (Throwable e) {
                    this.logger.error("\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u52a0\u8f7d\u56de\u5355\u4e1a\u52a1Download\u5b9e\u73b0\u7c7b\u5f02\u5e38", e);
                }
            }
        }
        ISDKDownloadReceiptHandle isdkDownloadReceiptHandle = cacheMap.get(bankVersionID);
        return isdkDownloadReceiptHandle;
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        ISDKDownloadReceiptHandle isdkDownloadReceiptHandle = this.getImplFromCache();
        try {
            List sdkReceiptDetails = SDKFetchDataUtil.getReceiptDetailById((long)request.getTaskId());
            SDKBankReceiptHandleResponse receiptHandleResponse = isdkDownloadReceiptHandle.doBiz(this.transFormat(request), sdkReceiptDetails);
            List result = receiptHandleResponse.getResult();
            DownloadListDetailService downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
            List downloadListDetails = downloadListDetailService.selectByRefId(request.getTaskId());
            HashSet existReceiptSet = Sets.newHashSetWithExpectedSize((int)1);
            for (DownloadListDetail downloadListDetail : downloadListDetails) {
                if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                existReceiptSet.add(downloadListDetail.getFileName());
            }
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
            String bakPath = SDKFetchDataUtil.getReceiptFileStoragePath((String)request.getAccNo(), (LocalDate)request.getTransDate());
            for (SDKReceiptDetail sdkReceiptDetail : result) {
                File receipt;
                String fileName = sdkReceiptDetail.getFileName();
                if (!existReceiptSet.contains(sdkReceiptDetail.getFileName()) && !(receipt = FileCommonUtils.getFileByPath((String)bakPath, (String)sdkReceiptDetail.getFileName())).exists()) {
                    throw new ReceiptException(ResManager.loadKDString((String)"\u8bf7\u5c06\u56de\u5355\u6587\u4ef6\u653e\u5728\u56fa\u5b9a\u76ee\u5f55\u4e0b\uff0c\u56fa\u5b9a\u76ee\u5f55\u83b7\u53d6\u65b9\u5f0f\u901a\u8fc7SDKFetchReceiptDataUtil.getReceiptFileStoragePath\u65b9\u6cd5\u83b7\u53d6\u3002", (String)"ReceiptDownloadImpl_0", (String)"ebg-receipt-banks-cus", (Object[])new Object[0]));
                }
                if (countMap.containsKey(fileName)) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u540d[%s]\u91cd\u590d,\u8bf7\u8c03\u6574\u56de\u5355\u6587\u4ef6\u540d\u7ec4\u6210\u89c4\u5219\uff0c\u4fdd\u8bc1\u552f\u4e00\u3002", (String)"ReceiptDownloadImpl_1", (String)"ebg-receipt-banks-cus", (Object[])new Object[0]), fileName));
                }
                countMap.put(fileName, 0);
            }
            return this.transFormat(receiptHandleResponse, request.getHeader());
        }
        catch (Throwable e) {
            throw new ReceiptException(e);
        }
    }
}

