/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.itbjfcl.dc.receipt.service.api;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.itbjfcl.dc.receipt.service.utils.Helper;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/FrontEnd/FrontEndServlet");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = JDomUtils.createRoot((String)"Iss_Itreasury");
        Element queryReq = JDomUtils.addChild((Element)root, (String)"QueryReq");
        boolean innerAcnt = Helper.isInnerAcnt((String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)queryReq, (String)"OperationType", (String)(innerAcnt ? "3" : "8"));
        JDomUtils.addChild((Element)queryReq, (String)"SystemID", (String)"ERP");
        JDomUtils.addChild((Element)queryReq, (String)"SendTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS")));
        Element queryContent = JDomUtils.addChild((Element)queryReq, (String)"QueryContent");
        JDomUtils.addChild((Element)queryContent, (String)"AccountNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)queryContent, (String)"TransactionTypeCode", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"ExcuteDateStart", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)queryContent, (String)"ExcuteDateEnd", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String currentPage = this.getCurrentPage();
        JDomUtils.addChild((Element)queryContent, (String)"QueryPageNumber", (String)(currentPage.equals("0") ? "1" : currentPage));
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE1", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE2", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE3", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE4", (String)"");
        JDomUtils.addChild((Element)queryContent, (String)"REVERSE5", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element queryRen = JDomUtils.getChildElement((Element)root, (String)"QueryRen");
        String processCode = JDomUtils.getChildText((Element)queryRen, (String)"ProcessCode");
        String processDesc = JDomUtils.getChildText((Element)queryRen, (String)"ProcessDesc");
        if (!"0000".equalsIgnoreCase(processCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s\u9519\u8bef\u4fe1\u606f:%1$s\u3002", (String)"DetailImpl_3", (String)"ebg-receipt-banks-itbjfcl-dc", (Object[])new Object[0]), processCode, processDesc));
        }
        String totalCount = JDomUtils.getChildText((Element)queryRen, (String)"TotalCount");
        String curCount = JDomUtils.getChildText((Element)queryRen, (String)"CurCount");
        String queryNextPage = JDomUtils.getChildText((Element)queryRen, (String)"QueryNextPage");
        if (StringUtils.isEmpty((String)queryNextPage) || "0".equalsIgnoreCase(queryNextPage)) {
            this.setLastPage(true);
        }
        if ("0".equalsIgnoreCase(totalCount) || "0".equalsIgnoreCase(curCount)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        this.setCurrentPage(queryNextPage);
        List elements = queryRen.getChildren("RenContent");
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        for (Element renContent : elements) {
            String s_toutfo = JDomUtils.getChildText((Element)renContent, (String)"s_toutfo");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setReversed1(s_toutfo);
            details.add(detailInfo);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "Detail";
    }

    public String getBizDesc() {
        return null;
    }

    public List<DetailInfo> queryTransDetail(String accNo, LocalDate startDate, LocalDate endDate) {
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        bankDetailRequest.setStartDate(startDate);
        bankDetailRequest.setEndDate(endDate);
        bankDetailRequest.setHeader(header);
        this.setCurrentPage("0");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(bankDetailRequest);
            List receiveItems = response.getDetails();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

