/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zyb.dc.service.detail;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zyb.dc.utils.DateUtils;
import kd.ebg.receipt.banks.zyb.dc.utils.GLBParser;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest request, String pageTag) throws EBServiceException {
        return this.parseTodayDetail(request, pageTag);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest arg0, String arg1) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankAcnt acnt = arg0.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)arg1, (String)encoding);
        Element head = ebenk.getChild("Sys_Head");
        Element body = ebenk.getChild("Body");
        if (!"000000".equals(head.getChildTextTrim("ReturnCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 \uff1a%s\u3002", (String)"DetailParser_1", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]), head.getChildText("ReturnMsg"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element TransList = body.getChild("List");
        List list = TransList.getChildren("Row");
        if (list.size() == 0) {
            return detailList;
        }
        for (int i = 0; i < list.size(); ++i) {
            DetailInfo detail = new DetailInfo();
            Element row = (Element)list.get(i);
            String currency = row.getChildText("Currency");
            detail.setCurrency(currency);
            String acctNo = row.getChildTextTrim("OtherAcNo");
            String accountName = row.getChildTextTrim("OtherName");
            String accountOpenNode = row.getChildTextTrim("OthBankName");
            detail.setOppAccNo(acctNo);
            detail.setOppAccName(accountName);
            detail.setOppBankName(accountOpenNode);
            String transferDate = row.getChildTextTrim("TransDate");
            String transferTime = row.getChildTextTrim("TransTime");
            String transTime = GLBParser.convJsonDateToString((String)(transferDate + " " + transferTime), (String)"yyyy-MM-dd hh:mm:ss");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                date = simpleDateFormat.parse(transTime);
            }
            catch (ParseException e) {
                this.log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef" + e.toString());
            }
            detail.setTransTime(DateUtils.dateTolocalDateTime((Date)date));
            detail.setTransDate(DateUtils.dateTolocalDate((Date)date));
            String payAmount = row.getChildTextTrim("Amount") == "" ? "0.00" : row.getChildTextTrim("Amount");
            String Reference = row.getChildTextTrim("Reference");
            detail.setExplanation(Reference);
            String CDFlag = row.getChildTextTrim("DCFlag");
            detail.setKdFlag(CDFlag);
            detail.setReversed1(payAmount);
            detailList.add(detail);
        }
        return detailList;
    }
}

