/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zyb.dc.service.detail;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.zyb.dc.service.detail.DetailPacker;
import kd.ebg.receipt.banks.zyb.dc.service.detail.DetailParser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    public String pack(BankDetailRequest request) {
        DetailPacker detailPacker = new DetailPacker();
        String rqstStr = detailPacker.packHisDetail(request, this.getCurrentPage());
        return rqstStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse bankDetailResponse = new EBBankDetailResponse();
        DetailParser detailParser = new DetailParser();
        List<DetailInfo> detailInfos = detailParser.parseHisDetail(request, responseStr);
        bankDetailResponse.setDetails(detailInfos);
        this.processPageTag(responseStr);
        return bankDetailResponse;
    }

    private void processPageTag(String responseStr) {
        int turnPageTotalNum;
        int turnPageShowNum;
        int pagetag = Integer.parseInt(this.getCurrentPage());
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element Body = root.getChild("Body");
        if (Body.getChildTextTrim("RecordNumber").length() <= 0 || Body.getChildTextTrim("RecordNumber") == null) {
            this.setLastPage(true);
        }
        if (pagetag - 1 + (turnPageShowNum = 100) >= (turnPageTotalNum = Integer.parseInt(Body.getChildTextTrim("RecordNumber")))) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(pagetag + 100);
            this.setLastPage(false);
        }
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "05B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"HisDetailImpl_0", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/bte-ebte/pay/q/actTransQuery?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("Password")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

