/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zyb.dc.service.receipt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zyb.dc.service.detail.HisDetailImpl;
import kd.ebg.receipt.banks.zyb.dc.service.receipt.api.ReceiptPrintImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"ZYB_DC", (String)accNo, (String)transDateStr);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List<DetailInfo> detailInfos = this.getDetailList(accNo, transDate);
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        for (DetailInfo detail : detailInfos) {
            String amount = detail.getReversed1();
            String CDFlag = detail.getKdFlag();
            String oppAccNo = detail.getOppAccNo();
            String Reference = detail.getExplanation();
            bankReceiptRequest.setRequestStr(Reference);
            ReceiptPrintImpl iBankReceipt = new ReceiptPrintImpl();
            BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)bankReceiptRequest);
            Map receiptInfoMap = (Map)bankReceiptResponseEB.getData();
            String fileName = (String)receiptInfoMap.get("FileName");
            String fileContent = (String)receiptInfoMap.get("FileContent");
            StringBuilder newFileName = new StringBuilder();
            newFileName.append(accNo).append("_");
            newFileName.append(transDateStr).append("_");
            newFileName.append(Reference).append("_");
            newFileName.append(amount).append("_");
            newFileName.append(CDFlag).append("_");
            newFileName.append(oppAccNo).append(".pdf");
            logger.info("{}-{}-\u94f6\u884c\u8fd4\u56de\u7684\u56de\u5355\u6587\u4ef6\u540d\uff1a{}", new Object[]{accNo, transDateStr, fileName});
            StringBuilder saveFilePathBuilder = new StringBuilder(bakFilePath);
            saveFilePathBuilder.append(File.separator).append((CharSequence)newFileName);
            String saveFilePath = saveFilePathBuilder.toString();
            if (!BankReceiptFetchListImpl.base64ToFile(fileContent, saveFilePath)) continue;
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileName);
            downloadListDetail.setFileName(newFileName.toString());
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DetailInfo> getDetailList(String accNo, LocalDate transDate) {
        HisDetailImpl hisDetail = new HisDetailImpl();
        BankDetailRequest historyDetailRequest = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        historyDetailRequest.setHeader(header);
        historyDetailRequest.setStartDate(transDate);
        historyDetailRequest.setEndDate(transDate);
        EBBankDetailResponse response = hisDetail.hisDetail(historyDetailRequest);
        return response.getDetails();
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ZYB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-zyb-dc", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean base64ToFile(String fileContent, String filepath) {
        logger.info("\u6b63\u5728\u4ece\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6...");
        File file = null;
        FileOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            file = FileCommonUtils.getFileByPath((String)filepath);
            if (!file.exists()) {
                boolean isCreate = file.createNewFile();
                logger.info("\u521b\u5efa\u6587\u4ef6\uff1a{}\uff0c\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{filepath, isCreate});
            }
            byte[] bytes = Base64.getDecoder().decode(fileContent);
            in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            out.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            logger.info("\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6\u5b8c\u6210");
        }
        return true;
    }
}

