/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.psbc.srdc.service.detail;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.psbc.srdc.service.util.DomHelper;
import kd.ebg.receipt.banks.psbc.srdc.service.util.Packer;
import kd.ebg.receipt.banks.psbc.srdc.service.util.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest request) {
        Element root = Packer.createReqRootElement((String)"1026");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Begin_Date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"End_Date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"PageNo", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)Param, (String)"PageNum", (String)"30");
        JDomUtils.addChild((Element)Param, (String)"Return_Flag", (String)"0");
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equalsIgnoreCase(protocol)) {
            return xmlStr;
        }
        String requestStr = Packer.createCommonMsg((String)xmlStr);
        return requestStr;
    }

    public String recv(InputStream inputStream) {
        return DetailImpl.parseRecvMsg(super.recv(inputStream));
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            if ("http".equalsIgnoreCase(protocol)) {
                return input;
            }
            return input.substring(10);
        }
        return "";
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = null;
        try {
            root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        }
        catch (Exception e) {
            log.error("\u90ae\u50a8\u94f6\u884c\u65b0\u7248\u672c-1026\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5f02\u5e38\uff1a", (Throwable)e);
            log.info("\u90ae\u50a8\u94f6\u884c\u65b0\u7248\u672c-1026\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
        BankResponse bankResponse = Parser.checkResponse((Element)root, (String)ResManager.loadKDString((String)"\u5b9a\u65e5\u671f\u4ea4\u6307\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
        if ("012717".equals(bankResponse.getResponseCode())) {
            this.setLastPage(true);
            detailResponse.setDetails(new ArrayList());
            this.setCurrentPage("");
            return detailResponse;
        }
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002", (String)"DetailImpl_17", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), request.getAcnt().getAccNo()) + String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001[%s]\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u3002", (String)"DetailImpl_18", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), EBGStringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()}))));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        String nextPage = Param.getChildText("NextPage");
        if (EBGStringUtils.isEmpty((String)nextPage) || "-1".equals(nextPage)) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(nextPage);
        }
        List RecordSet = Param.getChildren("RecordSet");
        if (RecordSet.size() == 0) {
            detailResponse.setDetails(new ArrayList());
            this.setCurrentPage("");
            return detailResponse;
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < RecordSet.size(); ++i) {
            DetailInfo detail;
            String Amount;
            String reserved2;
            String Bank_Serial;
            block15: {
                String Cust_Acct;
                Element record = (Element)RecordSet.get(i);
                String tempCust_Acct = Cust_Acct = DomHelper.getChildTextNotNull(record, "Query_Account", ResManager.loadKDString((String)"\u4ea4\u6613\u8d26\u53f7", (String)"DetailImpl_5", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                if (Cust_Acct.length() != request.getAcnt().getAccNo().length() && request.getAcnt().getAccNo().length() + 5 == Cust_Acct.length()) {
                    tempCust_Acct = Cust_Acct.substring(0, Cust_Acct.length() - 5);
                }
                if (!tempCust_Acct.equals(request.getAcnt().getAccNo())) {
                    EBServiceException exception = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7(%1$s)\u548c\u8bf7\u6c42\u8d26\u53f7(%2$s)\u4e0d\u7b26\u3002", (String)"DetailImpl_19", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), Cust_Acct, request.getAcnt().getAccNo()));
                    log.info("", (Object)exception);
                    throw exception;
                }
                String Name = DomHelper.getChildTextNullAsBlank(record, "Name");
                String Account = DomHelper.getChildTextNotNull(record, "Account", ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"DetailImpl_9", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                String Bank = DomHelper.getChildTextNullAsBlank(record, "Bank");
                Bank_Serial = DomHelper.getChildTextNotNull(record, "Bank_Serial", ResManager.loadKDString((String)"\u94f6\u884c\u6d41\u6c34\u53f7", (String)"DetailImpl_10", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                String Trans_Date = DomHelper.getChildTextNotNull(record, "Trans_Date", ResManager.loadKDString((String)"\u8f6c\u8d26\u65e5\u671f", (String)"DetailImpl_11", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                String Trans_Time = DomHelper.getChildTextNotNull(record, "Trans_Time", ResManager.loadKDString((String)"\u8f6c\u8d26\u65f6\u95f4", (String)"DetailImpl_12", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                reserved2 = DomHelper.getChildTextNullAsBlank(record, "Reserved2");
                Amount = DomHelper.getChildTextNotNull(record, "Amount", ResManager.loadKDString((String)"\u53d1\u751f\u91d1\u989d", (String)"DetailImpl_13", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                detail = new DetailInfo();
                detail.setAccNo(request.getAcnt().getAccNo());
                detail.setAccName(request.getAcnt().getAccName());
                detail.setOppAccNo(Account);
                detail.setOppAccName(Name);
                detail.setOppBankName(Bank);
                try {
                    if (!EBGStringUtils.isEmpty((String)Trans_Date)) {
                        if (!EBGStringUtils.isEmpty((String)Trans_Time)) {
                            detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                            detail.setTransTime(LocalDateTime.parse(Trans_Date + Trans_Time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                        } else {
                            detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                            detail.setTransTime(LocalDateTime.parse(Trans_Date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                        }
                        break block15;
                    }
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u201c\u8f6c\u8d26\u65e5\u671f\u201d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u65e5\u671f\u3002", (String)"DetailImpl_14", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:%s\u3002", (String)"DetailImpl_20", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
            detail.setReceiptNo(Bank_Serial);
            detail.setExplanation(reserved2);
            detail.setUniqueSeq(Amount);
            totalList.add(detail);
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "1026";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_16", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equalsIgnoreCase(protocol)) {
            String requesturl = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
            factory.setUri(requesturl);
            factory.setHttpHeader("content-type", "application/xml;charset=GBK");
        } else {
            factory.setHttpHeader("Content-Type", "text/xml");
        }
    }
}

