/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.crcb.dc.service.helper.JDOMHelper;
import kd.ebg.receipt.banks.crcb.dc.service.helper.SHA1Encrypt;
import kd.ebg.receipt.banks.crcb.dc.service.helper.SvsSign;
import kd.ebg.receipt.banks.crcb.dc.service.login.LoginImpl;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class RequestPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(RequestPacker.class);

    public static String getLoginMessage() {
        String customerId = RequestContextUtils.getBankParameterValue((String)"cust_no");
        String pass = RequestContextUtils.getBankParameterValue((String)"ciph");
        String reqTime = String.valueOf(System.currentTimeMillis());
        String serialNo = Sequence.gen18Sequence();
        SHA1Encrypt encrytyp = new SHA1Encrypt();
        String newPwd = encrytyp.getDigestOfString((customerId + pass).getBytes());
        String header = "-1|CL0001|" + serialNo + "|" + reqTime + "|#";
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("userID", customerId);
        requestMap.put("userPWD", newPwd);
        String loginMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, "CL0001");
        String signData = "";
        try {
            signData = SvsSign.getInstance().signData(loginMessage);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u767b\u9646\u7b7e\u540d\u5931\u8d25", (String)"RequestPacker_0", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)signData)) {
            signData = "-1";
        }
        String requestData = JDOMHelper.requestHttpMessage(header, signData, loginMessage);
        logger.info("requestData:" + requestData);
        return requestData;
    }

    public static String getHeader(String transCode) {
        Map<String, Object> resLoginMap = LoginImpl.getInstance().login();
        if (resLoginMap != null && StringUtils.equals((String)"00000000", (String)(resLoginMap.get("retCode") == null ? "" : resLoginMap.get("retCode").toString()))) {
            String reqTime = String.valueOf(System.currentTimeMillis());
            String sessionId = resLoginMap.get("sessionId").toString();
            String serialNo = resLoginMap.get("serialNo").toString();
            String header = sessionId + "|" + transCode + "|" + serialNo + "|" + reqTime + "|#";
            return header;
        }
        logger.info("\u767b\u9646\u5931\u8d25\uff01");
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u767b\u9646\u5931\u8d25!", (String)"RequestPacker_1", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]));
    }

    public static String packReceiptQueryMessage(String accNo, LocalDate transDate, int startIndex) {
        String header = RequestPacker.getHeader("CL0146");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)16);
        requestMap.put("StartRec", startIndex);
        requestMap.put("QryNum", "100");
        requestMap.put("AcctNo", accNo);
        requestMap.put("beginDate", transDateStr);
        requestMap.put("endDate", transDateStr);
        requestMap.put("PrtTyp", "2");
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, "CL0146");
        logger.info("reqMessage: " + reqMessage);
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u6253\u5305\u56de\u5355\u67e5\u8be2\u62a5\u6587\u63a5\u53e3(CL0146)\u5931\u8d25 ", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6253\u5305\u56de\u5355\u67e5\u8be2\u62a5\u6587\u63a5\u53e3(CL0146)\u5931\u8d25\u3002", (String)"RequestPacker_2", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "";
    }

    public static String packReceiptCreateMessage(String accNo, LocalDate transDate, String jsonStr) {
        String header = RequestPacker.getHeader("CL0147");
        Element root = new Element("CQRCBBankData");
        Element orReq = JDomUtils.addChild((Element)root, (String)"opReq");
        Element ReqParam = JDomUtils.addChild((Element)orReq, (String)"ReqParam");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        JDomUtils.addChild((Element)ReqParam, (String)"StartRec", (String)"0");
        JDomUtils.addChild((Element)ReqParam, (String)"QryNum", (String)"1");
        JDomUtils.addChild((Element)ReqParam, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"PrtTyp", (String)"2");
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)transDateStr);
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)transDateStr);
        Element listSet = JDomUtils.addChild((Element)ReqParam, (String)"LIST");
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String dtalSeq = jsonObject.getString("DtalSeq");
        String txnSeqNo = jsonObject.getString("TxnSeqNo");
        Element reqParam = JDomUtils.addChild((Element)listSet, (String)"RECORD");
        JDomUtils.addChild((Element)reqParam, (String)"TxnDt", (String)transDateStr);
        JDomUtils.addChild((Element)reqParam, (String)"DtalSeq", (String)dtalSeq);
        JDomUtils.addChild((Element)reqParam, (String)"TxnSeqNo", (String)txnSeqNo);
        String xmlStr = JDomUtils.root2String((Element)ReqParam, (String)"UTF-8");
        String reqMessage = xmlStr = xmlStr.substring(xmlStr.indexOf("<ReqParam>"), xmlStr.indexOf("</ReqParam>") + "</ReqParam>".length());
        logger.info("\u539f\u59cb\u62a5\u6587" + reqMessage);
        String signData = "";
        try {
            signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u7b7e\u540d\u540e\u62a5\u6587" + reqMessage);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u4ee3\u53d1\u5de5\u8d44\u7b7e\u540d\u5931\u8d25", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7b7e\u540d\u5931\u8d25\u3002", (String)"RequestPacker_3", (String)"ebg-receipt-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "-1";
    }
}

