/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.arcu.dc.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            boolean flag = this.download(downloadListDetail, request.getBankLoginId(), bankFtpProperties, bakFilePath, i == downloadListDetails.size() - 1);
            if (!flag) continue;
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String bankLoginId, BankFtpProperties bankFtpProperties, String bakFilePath, boolean isLastFile) {
        File file;
        LocalDate transDate = detail.getTransDate();
        String localDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String accNo = detail.getAccNo();
        String fileName = detail.getFileName();
        String sftp_path = bankFtpProperties.getFtpPath();
        sftp_path = StringUtils.isEmpty((String)sftp_path) ? "/" + localDate : sftp_path + "/" + localDate;
        boolean flag = false;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            ChannelSftp sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            try {
                SFTPUtils.getInstance().downloadSingleFile(sftp_path, fileName, bakFilePath, sftp);
            }
            catch (ReceiptException e) {
                try {
                    localDate = transDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    sftp_path = bankFtpProperties.getFtpPath();
                    sftp_path = StringUtils.isEmpty((String)sftp_path) ? "/" + localDate : sftp_path + "/" + localDate;
                    flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, detail.getFileLink(), bakFilePath, sftp);
                }
                catch (ReceiptException ee) {
                    logger.info("\u4e0b\u8f7d\u5931\u8d25{}", (Object)ee);
                    return false;
                }
            }
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            logger.info("\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6=====");
            String ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + localDate;
            List<String> tempFiles = this.getFileByName(detail.getFileLink(), accNo, transDate, ftpPath);
            logger.info("\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6===== tempFiles {}", (Object)tempFiles.toString());
            if (tempFiles.isEmpty()) {
                localDate = transDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + localDate;
                tempFiles = this.getFileByName(detail.getFileLink(), accNo, transDate, ftpPath);
            }
            if (!tempFiles.isEmpty()) {
                logger.info("\u524d\u7f6e\u673a\u83b7\u53d6\u8fd4\u56de\u7684\u6587\u4ef6\u4e2a\u6570\uff1a{}", (Object)tempFiles.size());
                for (String tempFileName : tempFiles) {
                    if (!tempFileName.contains(fileName)) continue;
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, fileName, bakFilePath);
                }
            }
        }
        if ((file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName))).exists()) {
            logger.info("\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6=====path:{} ", (Object)(bakFilePath + detail.getFileName()));
            detail.setBankFilePath(bakFilePath + File.separator + fileName);
            flag = true;
        }
        logger.info("sftp\u4e0b\u8f7d-{}-{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, detail.getFileLink(), flag});
        return flag;
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String frontProxyPath) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, "", frontProxyPath);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ARCU_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b89\u5fbd\u519c\u4fe1\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-arcu-dc", (Object[])new Object[0]);
    }
}

