/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.lzb.dc.service.receipt.download;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.lzb.dc.service.receipt.api.BankReceiptDownloadRequestImpl;
import kd.ebg.receipt.banks.lzb.dc.service.receipt.api.BankReceiptQueryRequestImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        try {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
            }
            BankReceiptQueryRequestImpl bankReceiptQueryRequest = new BankReceiptQueryRequestImpl();
            BankReceiptDownloadRequestImpl bankReceiptDownloadRequest = new BankReceiptDownloadRequestImpl();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().paramsMap((Map)paramMap).build();
            for (int i = 0; i < downloadListDetails.size(); ++i) {
                DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
                String fileName = downloadListDetail.getFileName();
                String fileLink = downloadListDetail.getFileLink();
                if (!fileName.endsWith(".zip")) continue;
                JSONObject jsonObject = JSONObject.parseObject((String)fileLink);
                String batchNo = jsonObject.getString("batch_no");
                String applyDate = jsonObject.getString("apply_date");
                paramMap.put("batch_no", batchNo);
                paramMap.put("apply_date", applyDate);
                BankReceiptResponseEB receiptResponseEB = bankReceiptQueryRequest.doBiz(bankReceiptRequest);
                if (receiptResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) throw new RuntimeException(receiptResponseEB.getMessage());
                BankReceiptResponseEB downloadResponseEB = bankReceiptDownloadRequest.doBiz(bankReceiptRequest);
                String zipName = (String)downloadResponseEB.getData();
                if (!EBGStringUtils.isNotEmpty((String)zipName)) continue;
                result.addAll(this.download(fileLink, sftp, accNo, transDate, bankFtpProperties, zipName, bakFilePath));
            }
            if (sftp == null) return BankReceiptHandleResponseEB.success(result);
        }
        catch (Throwable throwable) {
            if (sftp == null) throw throwable;
            SFTPUtils.getInstance().close(sftp);
            throw throwable;
        }
        SFTPUtils.getInstance().close(sftp);
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(String fileLink, ChannelSftp sftp, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, String zipName, String bakFilePath) {
        ArrayList<DownloadListDetail> downloadListDetailList = new ArrayList<DownloadListDetail>(1);
        boolean downloadFlag = false;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            String ftpPath = EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? "/" : bankFtpProperties.getFtpPath();
            downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, zipName, bakFilePath, sftp);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
            String frontProxyPath = bankFtpProperties.getFrontProxyPath();
            downloadFlag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath, zipName, bakFilePath);
        }
        if (downloadFlag && GZFileUtils.unTarFiles((String)(bakFilePath + File.separator + zipName), (String)bakFilePath)) {
            String tarNamePath = zipName.replace(".tar", "");
            File bakFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + tarNamePath));
            for (File receiptFile : bakFile.listFiles()) {
                if (receiptFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
                    String newFileName = String.format("%s_%s", accNo, receiptFile.getName());
                    if (!FileCommonUtils.moveFile((File)receiptFile, (String)bakFilePath, (String)newFileName)) continue;
                    DownloadListDetail downloadListDetail = new DownloadListDetail();
                    downloadListDetail.setFileLink(fileLink);
                    downloadListDetail.setFileName(newFileName);
                    downloadListDetailList.add(downloadListDetail);
                    continue;
                }
                FileCommonUtils.deleteFile((File)receiptFile);
            }
            FileCommonUtils.deleteFile((String)(bakFilePath + File.separator + zipName));
            FileCommonUtils.deleteFile((String)(bakFilePath + File.separator + bakFilePath + File.separator + tarNamePath));
        }
        return downloadListDetailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return null;
    }
}

