/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.lzb.dc.service.receipt.utils;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.constant.RetryErrorEnum;
import org.jdom2.Element;

public class Parser {
    public static BankResponse parseResponeCode(Element root) {
        BankResponse rsp = new BankResponse();
        Element head = root.getChild("head");
        String succ_flag = head.getChildTextTrim("succ_flag");
        String ret_code = head.getChildTextTrim("ret_code");
        String ret_info = head.getChildTextTrim("ret_info");
        rsp.setResponseCode(succ_flag + "_" + ret_code);
        rsp.setResponseMessage(ret_info);
        return rsp;
    }

    public static BankReceiptResponseEB parserReceiptQuery(String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u56de\u5355\u751f\u6210\u72b6\u6001\uff0c\u539f\u56e0:%1$s\uff0c%2$s\u3002", (String)"Parser_0", (String)"ebg-receipt-banks-lzb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String stat = body.getChildTextTrim("stat");
        if (Objects.equals(stat, "4")) {
            return BankReceiptResponseEB.success();
        }
        if (Objects.equals("1", stat) || Objects.equals("3", stat) || Objects.equals("7", stat)) {
            return BankReceiptResponseEB.fail((String)ResManager.loadKDString((String)"\u56de\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"Parser_1", (String)"ebg-receipt-banks-lzb-dc", (Object[])new Object[0]));
        }
        return BankReceiptResponseEB.fail((String)RetryErrorEnum.BANK_PROCESSING.getMsg());
    }

    public static BankReceiptResponseEB parserReceiptDownload(String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = Parser.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u56de\u5355\u751f\u6210\u72b6\u6001\uff0c\u539f\u56e0:%1$s\uff0c%2$s\u3002", (String)"Parser_0", (String)"ebg-receipt-banks-lzb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String file_name = body.getChildTextTrim("file_name");
        return BankReceiptResponseEB.success((Object)file_name);
    }

    public static void sleepInterval() {
        long value = 30000L;
        if (EBContext.getContext().isUnitTest()) {
            value = 1L;
        }
        try {
            String isNeedInterval = RequestContextUtils.getBankParameterValue((String)"is_need_interval");
            if (isNeedInterval == null) {
                isNeedInterval = "true";
            }
            if (Objects.equals(isNeedInterval, "true")) {
                Thread.sleep(value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

