/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.batch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BatchBankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BatchBankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        String bankLogin;
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        if (status.intValue() != TaskStatus.DOWNLOADING.getId()) {
            return false;
        }
        if (request.getTransDate().equals(LocalDate.now())) {
            return false;
        }
        if (!RequestContextUtils.receiptFormatIsFile() && !FileCommonUtils.isTestEnv()) {
            return false;
        }
        String bankVersion = EBContext.getContext().getBankVersionID();
        return RequestContextUtils.isSupportBatchDownloadByBankLogin((String)bankVersion, (String)(bankLogin = EBContext.getContext().getBankLoginID())) && request.getTransDate().isBefore(LocalDate.now());
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        List<DownloadListTask> tasks = this.getTasksByTransDateAndBankLogin(request);
        List ids = tasks.stream().map(o -> o.getId()).collect(Collectors.toList());
        List downloadListDetails = this.downloadListDetailService.findByRefids(ids);
        return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
    }

    public Map<String, List<DownloadListDetail>> getGroupList(List<DownloadListDetail> downloadListDetails) {
        HashMap maps = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            String accNo = downloadListDetail.getAccNo();
            if (!EBGStringUtils.isNotEmpty((String)accNo)) continue;
            ArrayList<DownloadListDetail> details = maps.containsKey(accNo) ? (ArrayList<DownloadListDetail>)maps.get(accNo) : new ArrayList<DownloadListDetail>(1);
            details.add(downloadListDetail);
            maps.put(accNo, details);
        }
        return maps;
    }

    public List<DownloadListTask> getTasksByTransDateAndBankLogin(BankReceiptHandleRequest receiptHandlerRequest) {
        String bankLoginId = receiptHandlerRequest.getBankLoginId();
        String customId = EBContext.getContext().getCustomID();
        LocalDate transDate = receiptHandlerRequest.getTransDate();
        List taskList = this.downloadTaskService.findByCustomIdAndBankLoginAndTransDateAndStatus(customId, bankLoginId, transDate, transDate, TaskStatusEnum.DOWNLOADING.getId());
        return taskList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

