/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.qdb.dc.service;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.qdb.dc.service.api.DetailImpl;
import kd.ebg.receipt.banks.qdb.dc.service.api.ReceiptRequestImpl;
import kd.ebg.receipt.banks.qdb.dc.service.util.ReceiptInfo;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<Object> result = new ArrayList<Object>(16);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        BankAcnt acnt = new BankAcnt();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"QDB_DC", (String)accNo, (String)transDateStr);
        logger.info("\u5373\u5c06\u67e5\u8be2>>>>>>>>" + accNo + "  " + EBContext.getContext().getCustomID());
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        logger.info("\u67e5\u8be2\u7ed3\u679c>>>>>>>>" + mainAcnt.getAccNo() + "  " + mainAcnt.getCurrency());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        logger.info("\u8f6c\u6362\u7ed3\u679c>>>>>>>>" + mainAcnt.getAccNo() + "  " + bankCurrency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankDetailRequest req = this.buildDetailRequest(acnt, transDate);
        EBBankDetailResponse detailResponse = new DetailImpl().detail(req);
        List details = detailResponse.getDetails();
        for (DetailInfo detail : details) {
            String receiptNo = detail.getReceiptNo();
            String reversed2 = detail.getReversed2();
            String fileName = receiptNo + ".pdf";
            if (existMap.containsKey(fileName)) {
                result.add(existMap.get(fileName));
                continue;
            }
            ReceiptInfo receiptInfo = ReceiptInfo.transform((String)(receiptNo + "_" + reversed2));
            BankReceiptRequest bankReceiptRequest = this.buildReq(acnt, transDate);
            HashMap<String, ReceiptInfo> paramsMap = new HashMap<String, ReceiptInfo>(2);
            paramsMap.put("receiptInfo", receiptInfo);
            bankReceiptRequest.setParamsMap(paramsMap);
            BankReceiptResponseEB responseEB = new ReceiptRequestImpl().doBiz(bankReceiptRequest);
            String fileContent = (String)responseEB.getData();
            FileCommonUtils.base64ToFile((String)fileContent, (String)(bakFilePath + File.separator + fileName));
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(receiptInfo.toJSONStr());
            downloadListDetail.setFileName(fileName);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReq(BankAcnt acnt, LocalDate localDate) {
        BankReceiptRequest req = BankReceiptRequest.builder().accNo(acnt.getAccNo()).transDate(localDate).build();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        req.setHeader(header);
        return req;
    }

    public BankDetailRequest buildDetailRequest(BankAcnt acnt, LocalDate localDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(localDate);
        request.setEndDate(localDate);
        return request;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bosh-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return false;
    }
}

