/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt.login;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class BankSignByNcImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    EBGLogger log = EBGLogger.getInstance().getLogger(((Object)((Object)this)).getClass());

    private String setSignHeader(String signSrc) {
        int length = 0;
        try {
            length = signSrc.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("\u4e0d\u652f\u6301\u7684\u7f16\u53f7");
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f\uff1a%s\u3002", (String)"BankSignByNcImpl_7", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        this.log.info("\u7b7e\u540d\u62a5\u6587Content-Length:{}", (Object)length);
        String header = "POST /servlet/ABC95599.Trans HTTP/1.1\r\nContent-Type: INFOSEC_SIGN/1.0\r\nContent-Length: " + length + "\r\nUser-Agent: Jakarta Commons-HttpClient/2.0.2\r\nHost: 127.0.0.1\r\n\r\n";
        return header;
    }

    public String getSign(String str) throws EBServiceException {
        Element root = BankSignByNcImpl.string2Root(str, RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String result = head.getChildText("result");
        String title = head.getChildText("title");
        if (!"0".equalsIgnoreCase(result)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"BankSignByNcImpl_8", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), title));
        }
        Element body = root.getChild("body");
        return body.getChildText("sign");
    }

    public static Element string2Root(String content, String encoding) throws EBServiceException {
        Document document = BankSignByNcImpl.string2Document(content, encoding);
        return document.getRootElement();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document string2Document(String content, String encoding) throws EBServiceException {
        Document document;
        String data = content;
        int startPoint = content.indexOf("<html");
        if (-1 != startPoint) {
            content = content.substring(startPoint);
        }
        content = "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>" + content;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(content.getBytes(encoding));
            SAXBuilder builder = new SAXBuilder();
            document = builder.build((InputStream)bais);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5b57\u7b26\u96c6%s\u3002", (String)"BankSignByNcImpl_9", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), encoding), (Throwable)e);
                catch (UTFDataFormatException e2) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5b57\u7b26\u96c6\u4e0d\u7b26\uff0c\u5b9e\u9645\u62a5\u6587\u5b57\u7b26\u96c6\u4e0d\u662f%s\u3002", (String)"BankSignByNcImpl_10", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), encoding), (Throwable)e2);
                }
                catch (Exception e3) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"XML\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%s\u3002", (String)"BankSignByNcImpl_11", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), data), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeInputStreamQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeInputStreamQuietly((InputStream)bais);
        return document;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String signSrc = bankReceiptRequest.getRequestStr();
        this.log.info("\u539f\u59cb\u7b7e\u540d\u6570\u636e\uff1a" + signSrc);
        try {
            String str = new String(signSrc.getBytes("GBK"), "ISO8859-1");
            signSrc = new String(str.getBytes("ISO8859-1"), "GBK");
            this.log.info("\u8f6c\u4e3aGBK\u7f16\u53f7\u540e\u7b7e\u540d\u6570\u636e:{}", (Object)signSrc);
            signSrc = this.setSignHeader(signSrc) + signSrc;
        }
        catch (UnsupportedEncodingException e) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6052\u4e30\u94f6\u884c\u7b7e\u540d\u63a5\u53e3\u6253\u5305\u5f02\u5e38\uff1a%s\u3002", (String)"BankSignByNcImpl_12", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return signSrc;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        responseStr = this.getSign(responseStr);
        return BankReceiptResponseEB.success((Object)responseStr);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "/servlet/ABC95599.Trans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7b7e\u540d\u670d\u52a1", (String)"BankSignByNcImpl_6", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String verifyIp = RequestContextUtils.getBankParameterValue((String)"ip");
        String verifyPort = RequestContextUtils.getBankParameterValue((String)"signPort");
        factory.setIp(verifyIp);
        factory.setPort(verifyPort);
        factory.setProtocol("TCP");
        factory.setHttpHeader("Content-Type", "INFOSEC_SIGN/1.0");
        EBContext.getContext().setCharsetName("GBK");
        this.log.info("\u6052\u4e30\u94f6\u884c\u7b7e\u540d\u670d\u52a1ip:{},\u7aef\u53e3:{}", new Object[]{verifyIp, verifyPort});
    }

    public static String sign(String signSrc) {
        BankSignByNcImpl bankSignByNc = new BankSignByNcImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(signSrc).build();
        BankReceiptResponseEB receiptResponseEB = bankSignByNc.doBiz(bankReceiptRequest);
        return (String)receiptResponseEB.getData();
    }
}

