/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.receipt.message;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.boc.net.service.receipt.BOCNETCommConfig;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.BocNetUtils;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.Packer;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.login.LoginAccess;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.login.LoginAccessManager;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class ReceiptPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptPacker.class);
    private static final int timeout = 840;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequstStr(String accNo, LocalDate startDate, LocalDate endDate, String bankLoginId) {
        BOCNETCommConfig bocnetCommConfig = (BOCNETCommConfig)EBConfigBuilder.getInstance().buildConfig(BOCNETCommConfig.class, bankLoginId);
        try {
            String customID = EBContext.getContext().getCustomID();
            String key = "eb_" + customID + "_" + bankLoginId + "_token";
            String token = CosmicCache.get((String)key);
            if (EBGStringUtils.isEmpty((String)token)) {
                LoginAccess la = LoginAccessManager.searchLock();
                try {
                    token = la.getToken();
                    CosmicCache.putIfAbsentWithExpire((String)key, (String)token, (int)840, (TimeUnit)TimeUnit.SECONDS);
                }
                finally {
                    try {
                        la.unavailableRelease();
                    }
                    catch (Exception exception) {}
                }
            }
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)bocnetCommConfig.getTermid());
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)bocnetCommConfig.getCustid());
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)bocnetCommConfig.getCusopr());
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0500");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0500-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0500-rq");
            JDomUtils.addChild((Element)rq, (String)"tratype", (String)"A");
            Element amtscope = JDomUtils.addChild((Element)rq, (String)"amtscope");
            JDomUtils.addChild((Element)amtscope, (String)"minamt", (String)"");
            if (startDate.equals(LocalDate.now())) {
                BigDecimal max = new BigDecimal("100000000000");
                String dateTimeStr = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
                if (dateTimeStr.length() == 16) {
                    dateTimeStr = dateTimeStr.substring(8, 14);
                }
                BigDecimal ram = new BigDecimal(dateTimeStr);
                JDomUtils.addChild((Element)amtscope, (String)"maxamt", (String)max.add(ram).toString());
            } else {
                JDomUtils.addChild((Element)amtscope, (String)"maxamt", (String)"");
            }
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)datescope, (String)"to", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            Element domaccount = JDomUtils.addChild((Element)rq, (String)"domaccount");
            JDomUtils.addChild((Element)domaccount, (String)"transact", (String)"");
            JDomUtils.addChild((Element)domaccount, (String)"transname", (String)"");
            JDomUtils.addChild((Element)rq, (String)"insid", (String)Packer.getTrnid());
            Element multidata = JDomUtils.addChild((Element)rq, (String)"multidata");
            Element confirmdata = JDomUtils.addChild((Element)multidata, (String)"confirmdata");
            JDomUtils.addChild((Element)confirmdata, (String)"actacn", (String)accNo);
            JDomUtils.addChild((Element)confirmdata, (String)"ibknum", (String)"");
            String fileType = RequestContextUtils.getBankParameterValue((String)"receiptFileType");
            if (!StringUtils.isEmpty((String)fileType) && fileType.equalsIgnoreCase("OFD")) {
                JDomUtils.addChild((Element)rq, (String)"filetype", (String)"OFD");
            }
            return JDomUtils.root2String((Element)root, (String)bocnetCommConfig.getCharset());
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
    }
}

