/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.reconciliation.api;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.boc.net.service.receipt.BOCNETCommConfig;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.utils.ReconciliationPacker;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.utils.ReconciliationParse;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliation;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class BankBalanceReconciliationQuery
extends AbstractBankReconciliationImpl
implements IBankReconciliation {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankBalanceReconciliationQuery.class);

    public String pack(BankReconciliationRequest request) {
        LocalDate transDate = request.getTransDate();
        String yearMonth = LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyyMM");
        String requestStr = "";
        ReconciliationPacker reconciliationPacker = new ReconciliationPacker();
        BOCNETCommConfig bocnetCommConfig = (BOCNETCommConfig)EBConfigBuilder.getInstance().buildConfig(BOCNETCommConfig.class, EBContext.getContext().getBankLoginID());
        requestStr = reconciliationPacker.packB2e0358(yearMonth, bocnetCommConfig);
        return requestStr;
    }

    public BankReconciliationResponseEB parse(BankReconciliationRequest request, String responseStr) {
        BOCNETCommConfig bocnetCommConfig = (BOCNETCommConfig)EBConfigBuilder.getInstance().buildConfig(BOCNETCommConfig.class, EBContext.getContext().getBankLoginID());
        ReconciliationParse reconciliationParse = new ReconciliationParse();
        List<String> result = reconciliationParse.parseB2e0358(responseStr, bocnetCommConfig);
        return BankReconciliationResponseEB.success(result);
    }

    public static List<String> queryBalanceReconciliationDetail(String accNo, LocalDate transDate) {
        ArrayList<String> detailInfos = new ArrayList<String>(1);
        BankBalanceReconciliationQuery bankBalanceReconciliationQuery = new BankBalanceReconciliationQuery();
        BankReconciliationRequest bankReceiptRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).build();
        bankBalanceReconciliationQuery.setCurrentPage("1");
        bankBalanceReconciliationQuery.setLastPage(false);
        while (!bankBalanceReconciliationQuery.isLastPage()) {
            BankReconciliationResponseEB response = bankBalanceReconciliationQuery.doBiz(bankReceiptRequest);
            if (Objects.nonNull(response) && Objects.nonNull(response.getData())) {
                detailInfos.addAll((List)response.getData());
                int currentPage = Integer.parseInt(bankBalanceReconciliationQuery.getCurrentPage());
                bankBalanceReconciliationQuery.setCurrentPage(currentPage + 1);
                continue;
            }
            bankBalanceReconciliationQuery.setLastPage(true);
        }
        return detailInfos;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "b2e0358";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u5355\u67e5\u8be2\u3002", (String)"BankBalanceReconciliationQuery_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/B2EC/E2BServlet");
    }
}

