/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.reconciliation.utils;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.boc.net.service.receipt.BOCNETCommConfig;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.BocNetUtils;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.Packer;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.login.LoginAccess;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.login.LoginAccessManager;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.utils.BalanceReconciliation;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import org.jdom2.Element;

public class ReconciliationPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReconciliationPacker.class);
    private static final int timeout = 840;

    public String packB2e0358(String yearMonth, BOCNETCommConfig bocnetCommConfig) {
        Element root = this.createCommonRoot("b2e0358", bocnetCommConfig);
        Element trans = JDomUtils.addChild((Element)root, (String)"trans");
        Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0358-rq");
        Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0358-rq");
        JDomUtils.addChild((Element)rq, (String)"checkmonth", (String)yearMonth);
        JDomUtils.addChild((Element)rq, (String)"conagrno", (String)bocnetCommConfig.getConagrNo());
        if (Objects.equals(bocnetCommConfig.getIsDownloadOverdueReconciliation(), "false")) {
            JDomUtils.addChild((Element)rq, (String)"overdueflag", (String)"1");
        }
        if (EBGStringUtils.isNotEmpty((String)bocnetCommConfig.getCustType())) {
            JDomUtils.addChild((Element)rq, (String)"custType", (String)bocnetCommConfig.getCustType());
        }
        String currentPage = RequestContextUtils.getRunningParam((String)"pageKey");
        int startIndex = (Integer.parseInt(currentPage) - 1) * 35;
        JDomUtils.addChild((Element)rq, (String)"begnum", (String)Integer.toString(startIndex));
        JDomUtils.addChild((Element)rq, (String)"recnum", (String)"35");
        return JDomUtils.root2String((Element)root, (String)bocnetCommConfig.getCharset());
    }

    public String packB2e0359(String reconciliationNo, BOCNETCommConfig bocnetCommConfig) {
        Element root = this.createCommonRoot("b2e0359", bocnetCommConfig);
        Element trans = JDomUtils.addChild((Element)root, (String)"trans");
        Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0359-rq");
        Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0359-rq");
        JDomUtils.addChild((Element)rq, (String)"insid", (String)Packer.getTrnid());
        JDomUtils.addChild((Element)rq, (String)"stmtnum", (String)reconciliationNo);
        if (EBGStringUtils.isNotEmpty((String)bocnetCommConfig.getCustType())) {
            JDomUtils.addChild((Element)rq, (String)"custType", (String)bocnetCommConfig.getCustType());
        }
        return JDomUtils.root2String((Element)root, (String)bocnetCommConfig.getCharset());
    }

    public String packB2e0360(String reconciliationNo, boolean isSame, BOCNETCommConfig bocnetCommConfig, List<BalanceReconciliation> balanceReconciliations) {
        Element root = this.createCommonRoot("b2e0360", bocnetCommConfig);
        Element trans = JDomUtils.addChild((Element)root, (String)"trans");
        Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0360-rq");
        Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0360-rq");
        JDomUtils.addChild((Element)rq, (String)"stmtnum", (String)reconciliationNo);
        JDomUtils.addChild((Element)rq, (String)"isrestore", (String)(isSame ? "1" : "0"));
        JDomUtils.addChild((Element)rq, (String)"insid", (String)Packer.getTrnid());
        if (!isSame && balanceReconciliations != null) {
            if (balanceReconciliations.size() > 50) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u4f59\u989d\u53cd\u9988\u6761\u6570\u4e0d\u80fd\u8d85\u8fc750\u7b14\u3002", (String)"ReconciliationPacker_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
            }
            Element multiDataEl = JDomUtils.addChild((Element)rq, (String)"multidata");
            balanceReconciliations.forEach(info -> {
                Element confirmDataEl = new Element("confirmdata");
                String accNo = info.getAccNo();
                String bokbal = info.getBokbal();
                StringBuilder seqNo = new StringBuilder();
                seqNo.append(Sequence.gen16NumSequence()).append(Sequence.gen16NumSequence()).append("00");
                String vchnum = seqNo.toString();
                String amount = info.getAmount();
                String opreason = info.getOpreason();
                JDomUtils.addChild((Element)confirmDataEl, (String)"actacn", (String)accNo);
                JDomUtils.addChild((Element)confirmDataEl, (String)"bokbal", (String)bokbal);
                JDomUtils.addChild((Element)confirmDataEl, (String)"vchnum", (String)vchnum);
                JDomUtils.addChild((Element)confirmDataEl, (String)"amount", (String)amount);
                JDomUtils.addChild((Element)confirmDataEl, (String)"moddate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
                JDomUtils.addChild((Element)confirmDataEl, (String)"opreason", (String)opreason);
                JDomUtils.addChild((Element)multiDataEl, (Element)confirmDataEl);
            });
        } else {
            Element multiDataEl = JDomUtils.addChild((Element)rq, (String)"multidata");
            Element confirmDataEl = new Element("confirmdata");
            JDomUtils.addChild((Element)multiDataEl, (Element)confirmDataEl);
        }
        return JDomUtils.root2String((Element)root, (String)bocnetCommConfig.getCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        String key = this.getKey();
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String token = CosmicCache.get((String)key);
        if (EBGStringUtils.isEmpty((String)token)) {
            LoginAccess la = LoginAccessManager.searchLock();
            try {
                token = la.getToken();
                CosmicCache.putIfAbsentWithExpire((String)key, (String)token, (int)840, (TimeUnit)TimeUnit.SECONDS);
            }
            finally {
                try {
                    la.unavailableRelease();
                }
                catch (Exception exception) {}
            }
        }
        return token;
    }

    public String getKey() {
        String customID = EBContext.getContext().getCustomID();
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String key = "eb_" + customID + "_" + bankLoginId + "_token";
        return key;
    }

    public Element createCommonRoot(String transCode, BOCNETCommConfig bocnetCommConfig) {
        String token = this.getToken();
        Element root = BocNetUtils.createRoot();
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"termid", (String)bocnetCommConfig.getTermid());
        JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
        JDomUtils.addChild((Element)head, (String)"custid", (String)bocnetCommConfig.getCustid());
        JDomUtils.addChild((Element)head, (String)"cusopr", (String)bocnetCommConfig.getCusopr());
        JDomUtils.addChild((Element)head, (String)"trncod", (String)transCode);
        JDomUtils.addChild((Element)head, (String)"token", (String)token);
        return root;
    }
}

