/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.proxy.FileDownLoad;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.utils.Common;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.utils.EncodeAnDecodeHandler;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.utils.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.utils.ShowTipUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class QueryReceiptDetailImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReceiptDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "562150";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u3002", (String)"QueryReceiptDetailImpl_0", (String)"ebg-receipt-banks-jxnsb-cmp", (Object[])new Object[0]);
    }

    public String pack(BankReceiptRequest bankDetailRequest) {
        String req_no = Sequence.gen18Sequence();
        String tr_code = this.getBizCode();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)bankDetailRequest.getAccNo());
        String bankCurrency = bankDetailRequest.getHeader().getAcnt().getCurrency();
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankCurrency);
        JDomUtils.addChild((Element)body, (String)"start_date", (String)bankDetailRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)bankDetailRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"first_kind", (String)"0");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        xmlMsg = EncodeAnDecodeHandler.encode(xmlMsg);
        return Common.createCommonMsg(xmlMsg);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankDetailRequest, String responseStr) {
        responseStr = Common.parseRecvMsg(responseStr);
        responseStr = EncodeAnDecodeHandler.decode(responseStr);
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(8);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            logger.error("\u672c\u6b21\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u660e\u7ec6\u3002");
            return BankReceiptResponseEB.fail();
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equals(file_flag)) {
            logger.info("\u672c\u6b21\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = new FileDownLoad().doBiz(file_name);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u67e5\u8be2\u56de\u5355\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"QueryReceiptDetailImpl_1", (String)"ebg-receipt-banks-jxnsb-cmp", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            logger.info("\u672c\u6b21\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        String[][] r2 = this.parseRecord(content, recordNum, fieldNum);
        for (int k = 0; k < r2.length; ++k) {
            String[] r2_k = r2[k];
            DetailInfo detailInfo = this.parseR2(r2_k);
            details.add(detailInfo);
        }
        return BankReceiptResponseEB.success(details);
    }

    public DetailInfo parseR2(String[] r2_k) {
        DetailInfo detailInfo = new DetailInfo();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tr_acdt", (Object)r2_k[0]);
        jsonObject.put("tr_time", (Object)r2_k[1]);
        jsonObject.put("serial_no", (Object)r2_k[2]);
        jsonObject.put("acno", (Object)r2_k[3]);
        jsonObject.put("acname", (Object)r2_k[4]);
        jsonObject.put("as_acno", (Object)r2_k[5]);
        jsonObject.put("as_acname", (Object)r2_k[6]);
        jsonObject.put("amt", (Object)r2_k[7]);
        jsonObject.put("purpose", (Object)r2_k[8]);
        jsonObject.put("postscript", (Object)r2_k[9]);
        jsonObject.put("opp_acno", (Object)r2_k[10]);
        jsonObject.put("opp_acname", (Object)r2_k[11]);
        jsonObject.put("kind", (Object)r2_k[12]);
        jsonObject.put("crdr_flag", (Object)r2_k[13]);
        jsonObject.put("host_serial_no", (Object)r2_k[14]);
        detailInfo.setJson(jsonObject.toJSONString());
        return detailInfo;
    }

    public String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

