/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.download;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        Integer status = request.getTaskStatus();
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(1);
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        String bankLogin = request.getBankLoginId();
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        try {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
            }
            for (DownloadListDetail downloadListDetail : downloadListDetails) {
                if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                    result.add(downloadListDetail);
                    continue;
                }
                boolean isSuccess = this.download(downloadListDetail, bakFilePath, bankLogin, bankFtpProperties, sftp);
                if (!isSuccess) continue;
                result.add(downloadListDetail);
            }
            if (sftp == null) return BankReceiptHandleResponseEB.success(result);
        }
        catch (Throwable throwable) {
            if (sftp == null) throw throwable;
            SFTPUtils.getInstance().close(sftp);
            throw throwable;
        }
        SFTPUtils.getInstance().close(sftp);
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String bakFilePath, String bankLogin, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        boolean result = true;
        String ftpPath = "/";
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        try {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                if (SFTPUtils.getInstance().isAbort(sftp)) {
                    sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                }
                ftpPath = EBGStringUtils.isEmpty((String)(ftpPath = bankFtpProperties.getFtpPath())) ? "/" : ftpPath;
                result = SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileLink(), bakFilePath, sftp);
            } else {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                ftpPath = bankFtpProperties.getFrontProxyPath();
                result = bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, detail.getFileLink(), bakFilePath);
            }
            if (!result) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a%s\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-jxnsb-cmp", (Object[])new Object[0]), detail.getFileLink()));
            }
            return this.handleReceiptRar(detail.getFileLink(), bakFilePath, detail.getFileName());
        }
        catch (Exception e) {
            String msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileLink(), (String)e.getMessage());
            throw new ReceiptException(msg, (Throwable)e);
        }
    }

    public boolean handleReceiptRar(String rarName, String bakFilePath, String pdfName) {
        String lastPath = rarName.replace(".tar", "");
        String unRarPath = bakFilePath + File.separator + lastPath;
        if (GZFileUtils.unTarFiles((String)(bakFilePath + File.separator + rarName), (String)unRarPath)) {
            File unRarFile = FileCommonUtils.getFileByPath((String)unRarPath);
            File[] files = unRarFile.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (!file.getName().endsWith(".pdf")) continue;
                    return FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)pdfName);
                }
            }
        } else {
            return false;
        }
        return false;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

