/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bochk.dc.service.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.bochk.dc.service.utils.GetKeyStoreHelper;
import kd.ebg.receipt.banks.bochk.dc.service.utils.TxStatusType;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.sdk.ebg.trd.exception.SDKException;
import kd.sdk.ebg.trd.proxy.SDKPgpHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.jdom2.Element;

public class BOCHK_DC_Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BOCHK_DC_Parser.class);

    public static BankResponse parseHead(Element root) {
        BankResponse rsp = new BankResponse();
        Element head = root.getChild("Head");
        String TxStatus = head.getChildTextTrim("TxStatus");
        rsp.setResponseCode(TxStatus);
        TxStatusType txStatusType = TxStatusType.getTxStatusTypeById((String)TxStatus);
        String TxStatusMsg = "";
        TxStatusMsg = txStatusType != null ? txStatusType.getTypeMsg() : String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u975e\u6b63\u5e38\u54cd\u5e94\u7801%s\u3002", (String)"BOCHK_DC_Parser_0", (String)"ebg-receipt-banks-bochk-dc", (Object[])new Object[0]), TxStatus);
        rsp.setResponseMessage(TxStatusMsg);
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean base64ToFile(String fileContent, String filepath) {
        logger.info("\u6b63\u5728\u4ece\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6...");
        File file = null;
        FileOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            file = FileCommonUtils.getFileByPath((String)filepath);
            if (!file.exists()) {
                boolean isCreate = file.createNewFile();
                logger.info("\u521b\u5efa\u6587\u4ef6\uff1a{}\uff0c\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{filepath, isCreate});
            }
            byte[] bytes = Base64.decodeBase64((String)fileContent);
            in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            out.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            logger.info("\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6\u5b8c\u6210");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parsePGPMessage(String base64Msg) {
        String needPgp = RequestContextUtils.getBankParameterValue((String)"is_need_pgp");
        if (StringUtils.isEmpty((String)base64Msg)) return base64Msg;
        if (!"true".equalsIgnoreCase(needPgp)) {
            return base64Msg;
        }
        byte[] buf = Base64.decodeBase64((String)base64Msg);
        String privateKey = GetKeyStoreHelper.getPgpPrivateKey("custom_pgp_private_key");
        char[] password = RequestContextUtils.getBankParameterValue((String)"custom_pgp_private_key_ciper").toCharArray();
        try (ByteArrayInputStream in = new ByteArrayInputStream(buf);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SDKPgpHelper.getInstance().decryptStream((InputStream)in, (OutputStream)out, IOUtils.toInputStream((String)privateKey, (String)RequestContextUtils.getCharset()), password);
            String string = out.toString(RequestContextUtils.getCharset());
            return string;
        }
        catch (IOException | SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

