/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jxb.dc.service.receipt.api;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.jxb.dc.service.receipt.api.helper.Packer;
import kd.ebg.receipt.banks.jxb.dc.service.receipt.api.helper.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "eacqry.AcTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-jxb-dc", (Object[])new Object[0]);
    }

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        Element root = Packer.buildHead(Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"Currency", (String)RequestContextUtils.getRunningParam((String)"Currency"));
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"QryDir", (String)"A");
        JDomUtils.addChild((Element)body, (String)"QHTranstype", (String)"");
        JDomUtils.addChild((Element)body, (String)"pageSize", (String)"1000");
        JDomUtils.addChild((Element)body, (String)"currentIndex", (String)this.getCurrentPage());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser((Element)root);
        if (!"FIN0000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%1$s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001[%2$s]\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u3002", (String)"DetailImpl_1", (String)"ebg-receipt-banks-jxb-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element body = root.getChild("Body");
        Integer recordNumber = Integer.parseInt(body.getChildText("recordNumber"));
        if (recordNumber == 0) {
            this.setCurrentPage("");
            this.setLastPage(true);
            return BankReceiptResponseEB.success();
        }
        Element list = body.getChild("List");
        List records = list.getChildren("Record");
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Element dto = (Element)records.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(dto.getChildTextTrim("Currency"));
            String oppAccNo = dto.getChildTextTrim("YourRichNbr");
            if (StringUtils.isEmpty((String)oppAccNo)) {
                oppAccNo = "e";
            }
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(dto.getChildTextTrim("YourRichName"));
            String amount = dto.getChildTextTrim("Amount");
            detail.setReversed1(amount);
            String CDFlag = dto.getChildTextTrim("TransDir");
            detail.setReversed2(CDFlag);
            String TransNbr = dto.getChildTextTrim("TransNbr");
            detail.setReceiptNo(TransNbr);
            totalList.add(detail);
        }
        String num = body.getChildText("recordNumber");
        int retRecords = Integer.parseInt(StringUtils.isEmpty((String)num) ? "0" : num);
        if (retRecords < 1000) {
            this.logger.info("\u5f53\u524d\u7b14\u6570\u5c0f\u4e8e1000\uff0c\u4e3a\u6700\u540e\u4e00\u9875");
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1000 + "");
        }
        return BankReceiptResponseEB.success(totalList);
    }

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "eacqry.AcTrsQry", "0");
    }

    public List<DetailInfo> queryDetailList(String accNo, LocalDate transDate) {
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        RequestContextUtils.setRunningParam((String)"Currency", (String)bankCurrency);
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

