/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hsb.dc.service.receipt.utils;

import java.time.LocalDate;
import java.util.Date;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import org.jdom2.Element;

public class HSB_DC_Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HSB_DC_Packer.class);

    public static Element buildHead(String tr_code, String req_no, boolean file) {
        Element root = JDomUtils.createRoot((String)"ap");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)req_no);
        Date now = new Date();
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)DateTimeUtils.format((Date)now, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)DateTimeUtils.format((Date)now, (String)"HHmmss"));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"0");
        if (file) {
            JDomUtils.addChild((Element)head, (String)"file_flag", (String)"1");
        } else {
            JDomUtils.addChild((Element)head, (String)"file_flag", (String)"0");
        }
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return root;
    }

    public static String buildCommonMsg(String xmlStr) throws EBServiceException {
        StringBuilder buffer = new StringBuilder();
        String bankParameterValue = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("TCP".equals(bankParameterValue)) {
            int length = HSB_DC_Packer.getLength(xmlStr);
            buffer.append(HSB_DC_Packer.formatLen(Integer.toString(length + 2), 10));
        }
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static String packReceiptDetail(BankDetailRequest request) {
        Element root = HSB_DC_Packer.buildHead("03020104A0261", Sequence.gen18Sequence(), false);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"is_now_day", (String)(request.getEndDate().equals(LocalDate.now()) ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"bn_prt_flg", (String)"");
        JDomUtils.addChild((Element)body, (String)"prt_flg", (String)"N");
        JDomUtils.addChild((Element)body, (String)"start_date", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate()));
        JDomUtils.addChild((Element)body, (String)"tr_type", (String)"1");
        JDomUtils.addChild((Element)body, (String)"tot_rcrd_cnt", (String)(RequestContextUtils.getRunningParam((String)"tot_rcrd_cnt") == null ? "" : RequestContextUtils.getRunningParam((String)"tot_rcrd_cnt")));
        JDomUtils.addChild((Element)body, (String)"rcrd_cnt", (String)(RequestContextUtils.getRunningParam((String)"rcrd_cnt") == null ? "" : RequestContextUtils.getRunningParam((String)"rcrd_cnt")));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public static String packOneReceiptDownload(String serial_no, String account_seq, String tr_acdt) throws EBServiceException {
        Element root = HSB_DC_Packer.buildHead("03020104A0262", Sequence.gen18Sequence(), false);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"account_seq", (String)account_seq);
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)tr_acdt);
        JDomUtils.addChild((Element)body, (String)"vrtl_act_flag", (String)"N");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public static String formatLen(String orgStr, int exptecedLength) {
        try {
            String encoding = RequestContextUtils.getBankParameterValue((String)"charset");
            return StringFormater.formatLen((String)orgStr, (int)exptecedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }

    public static int getLength(String msg) throws EBServiceException {
        String encoding = RequestContextUtils.getBankParameterValue((String)"charset");
        try {
            int length = msg.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Object)e);
            return 0;
        }
    }
}

