/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzrcb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gzrcb.dc.service.receipt.utils.RequestPacker;
import kd.ebg.receipt.banks.gzrcb.dc.service.receipt.utils.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class BankReceiptInfoQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptInfoQueryImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Map paramsMap = request.getParamsMap();
        String sernum = (String)paramsMap.get("SERNUM");
        String userId = (String)paramsMap.get("userId");
        String TEST_TRANSDATE = (String)paramsMap.get("TEST_TRANSDATE");
        String receiptrequest = RequestPacker.receiptDownload(accNo, transDateStr, sernum, userId, TEST_TRANSDATE);
        return receiptrequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String fileName = ResponseParser.receiptParser(responseStr);
        return BankReceiptResponseEB.success((Object)fileName);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GZRCB_DC_RECEIPT_INFO_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e7f\u5dde\u519c\u5546\u94f6\u884c\u56de\u5355\u4fe1\u606f\u67e5\u8be2\u8bf7\u6c42\u3002", (String)"BankReceiptInfoQueryImpl_0", (String)"ebg-receipt-banks-gzrcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

