/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.fjnxs.dc.service;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.fjnxs.dc.service.api.B2EBillDownLoad;
import kd.ebg.receipt.banks.fjnxs.dc.service.api.B2EBillList;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(8);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDateStr + "\n");
        BankReceiptRequest b2EBillListReq = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr("1").build();
        BankReceiptResponseEB response = new B2EBillList().doBiz(b2EBillListReq);
        ArrayList bills = new ArrayList(8);
        if (Objects.nonNull(response.getData())) {
            bills.addAll((List)response.getData());
        }
        for (JSONObject bill : bills) {
            String billNo = bill.getString("BillNo");
            BankReceiptRequest b2EBillDownLoadReq = BankReceiptRequest.builder().accNo(accNo).requestStr(billNo).build();
            BankReceiptResponseEB resp = new B2EBillDownLoad().doBiz(b2EBillDownLoadReq);
            String fileName = (String)resp.getData();
            if (!StringUtils.isNotEmpty((String)fileName)) continue;
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(bill.toJSONString());
            result.add(downloadListDetail);
        }
        logger.info(">>>>>>>>>{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }
}

