/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.xmb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        List<Object> result = new ArrayList(16);
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = task.getTransDate();
        String accNo = task.getAccNo();
        boolean isPdf = Objects.equals(RequestContextUtils.getBankParameterValue((String)"receipt_type"), "pdf");
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"XMB_DC", (String)accNo, (String)transDateStr);
        String tempPath = FileStorageUtil.getFileBatchBakPathByTransDate((String)task.getBankLoginId(), (String)transDateStr);
        if (isPdf) {
            tempPath = bakPath;
        }
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, task.getBankLoginId());
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp();
        }
        try {
            if (isPdf) {
                List<String> fileNameList;
                String lastPath = "/" + transDateStr + "/" + accNo;
                String ftpPath = bankFtpProperties.getFrontProxyPath() + lastPath;
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    ftpPath = bankFtpProperties.getFtpPath() + lastPath;
                }
                if ((fileNameList = this.getFileNameListByPath(bankFtpProperties, sftp, accNo, transDate, ftpPath)).size() > 0) {
                    for (String fileName : fileNameList) {
                        boolean downloaded = this.downloadFileByFileName(bankFtpProperties, sftp, tempPath, fileName, accNo, transDate, ftpPath);
                        if (!downloaded) continue;
                        DownloadListDetail detail = new DownloadListDetail();
                        detail.setFileName(fileName);
                        result.add(detail);
                    }
                }
            } else {
                String ftpPath = bankFtpProperties.getFrontProxyPath();
                if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                    ftpPath = EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? "/" : bankFtpProperties.getFtpPath();
                }
                String zipFileName = "zzzd_bill_flow_general_pdf_" + transDateStr + ".zip";
                logger.info("\u51c6\u5907\u53bbSFTP\u4e0b\u8f7d\u6587\u4ef6.." + zipFileName);
                boolean downloadFlag = this.downloadFileByFileName(bankFtpProperties, sftp, tempPath, zipFileName, accNo, transDate, ftpPath);
                if (downloadFlag) {
                    result = this.getDetailList(task, zipFileName);
                }
            }
        }
        catch (Throwable e) {
            throw new ReceiptException(e);
        }
        finally {
            SFTPUtils.getInstance().close(sftp);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-xmb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<String> getFileNameListByPath(BankFtpProperties bankFtpProperties, ChannelSftp sftp, String accNo, LocalDate transDate, String ftpPath) throws Exception {
        ArrayList<String> fileNameList = new ArrayList<String>(1);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            Vector vector = SFTPUtils.getInstance().listFiles(ftpPath, sftp);
            for (Object l : vector) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)l;
                if (file.getAttrs().isDir() || !file.getFilename().endsWith(".pdf")) continue;
                fileNameList.add(file.getFilename());
            }
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
            return bankReceiptApiUtil.getFileByName(accNo, "pdf", ftpPath);
        }
        return fileNameList;
    }

    public boolean downloadFileByFileName(BankFtpProperties bankFtpProperties, ChannelSftp sftp, String tempPath, String fileName, String accNo, LocalDate transDate, String ftpPath) {
        boolean downloadFlag = false;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            downloadFlag = this.ftpDownload(tempPath, fileName, ftpPath, sftp);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            downloadFlag = this.frontProxyDownload(fileName, accNo, transDate, ftpPath, tempPath);
        }
        return downloadFlag;
    }

    private List<DownloadListDetail> getDetailList(DownloadListTask task, String zipFileName) {
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String tempPath = FileStorageUtil.getFileBatchBakPathByTransDate((String)task.getBankLoginId(), (String)transDateStr);
        List fileList = FileCommonUtils.readZipFiles((String)(tempPath + File.separator + zipFileName));
        if (fileList.size() == 0) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5305\u542bpdf\u683c\u5f0f\u7684\u56de\u5355\u6587\u4ef6\u3002", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-xmb-dc", (Object[])new Object[0]), zipFileName));
        }
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"XMB_DC", (String)task.getAccNo(), (String)transDateStr);
        if (GZFileUtils.unZipFiles((String)(tempPath + File.separator + zipFileName), (String)tempPath)) {
            logger.info("\u89e3\u538b\u5b8c\u6bd5...");
            ArrayList<String> parentFile = new ArrayList<String>(16);
            for (String receiptName : fileList) {
                File sourceFile = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + receiptName));
                String parentFileName = sourceFile.getParentFile().getName();
                if (!parentFile.contains(parentFileName)) {
                    parentFile.add(parentFileName);
                }
                String newReceiptName = sourceFile.getName();
                if (receiptName.contains(task.getAccNo()) && sourceFile.isFile()) {
                    DownloadListDetail detail = new DownloadListDetail();
                    detail.setFileName(newReceiptName);
                    detail.setTransDate(task.getTransDate());
                    detailList.add(detail);
                }
                if (!sourceFile.exists() || !sourceFile.isFile()) continue;
                FileCommonUtils.moveFile((File)sourceFile, (String)bakPath, (String)newReceiptName);
            }
            logger.info("\u8f6c\u79fb\u6587\u4ef6\u5230\u626b\u63cf\u76ee\u5f55\u5b8c\u6bd5...");
            for (String parentFileName : parentFile) {
                FileCommonUtils.getFileByPath((String)(tempPath + File.separator + parentFileName)).delete();
            }
            FileCommonUtils.getFileByPath((String)(tempPath + File.separator + zipFileName)).delete();
            logger.info("\u5220\u9664\u6587\u4ef6\u5b8c\u6bd5...");
        }
        return detailList;
    }

    private boolean frontProxyDownload(String orgFileName, String accNo, LocalDate transDate, String ftpPath, String tempPath) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, orgFileName, tempPath);
    }

    private boolean ftpDownload(String destFolder, String orgFileName, String ftpPath, ChannelSftp sftp) {
        return SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "XMB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u53a6\u95e8\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-xmb-dc", (Object[])new Object[0]);
    }
}

