/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ynnx.dc.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.detail.DetailInfoOnReceipt;
import kd.ebg.egf.common.utils.FetchDataUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ynnx.dc.service.receipt.api.GetOneBankReceiptFileImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String bankCurrency = request.getHeader().getAcnt().getCurrency();
        ArrayList<Object> result = new ArrayList<Object>(1);
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)request.getBankVersionId(), (String)accNo, (String)transDateStr);
        List detailInfoList = FetchDataUtils.queryDetailFromReceipt((String)request.getBankVersionId(), (String)request.getBankLoginId(), (String)accNo, (LocalDate)transDate, (String)bankCurrency);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)detailInfoList.size());
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        GetOneBankReceiptFileImpl getOneBankReceiptFileImpl = new GetOneBankReceiptFileImpl();
        for (DetailInfoOnReceipt detailInfoOnReceipt : detailInfoList) {
            try {
                String base64Str;
                String jsonStr = detailInfoOnReceipt.getJsonMap();
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                String JnlDate = jsonObject.getString("JnlDate");
                String JnlTime = jsonObject.getString("JnlTime");
                String DCFlag = jsonObject.getString("DCFlag");
                String Amount = jsonObject.getString("Amount");
                String Balance = jsonObject.getString("Balance");
                String TransJnlNo = jsonObject.getString("TransJnlNo");
                String AcctOrgan = jsonObject.getString("AcctOrgan");
                String fileName = this.packFileName(accNo, JnlDate, JnlTime, DCFlag, Amount, Balance, countMap);
                paramMap.put("TransJnlNo", TransJnlNo);
                paramMap.put("AcctOrgan", AcctOrgan);
                bankReceiptRequest.setParamsMap((Map)paramMap);
                bankReceiptRequest.setRequestStr(TransJnlNo);
                if (existMap.containsKey(fileName)) {
                    DownloadListDetail downloadListDetail = (DownloadListDetail)existMap.get(fileName);
                    downloadListDetail.setReceiptJson(jsonStr);
                    result.add(existMap.get(fileName));
                    continue;
                }
                BankReceiptResponseEB receiptResponseEB = getOneBankReceiptFileImpl.doBiz(bankReceiptRequest);
                if (receiptResponseEB.getCode() != BankReceiptHandleResponseEB.ResultEnum.SUCCESS.getCode() || !FileCommonUtils.base64ToFile((String)(base64Str = (String)receiptResponseEB.getData()), (String)(bakPath + File.separator + fileName))) continue;
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(fileName);
                downloadListDetail.setReceiptJson(jsonStr);
                downloadListDetail.setFileLink(TransJnlNo);
                result.add(downloadListDetail);
            }
            catch (Throwable e) {
                logger.error(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5931\u8d25", (String)"BankReceiptFetchImpl_0", (String)"ebg-receipt-banks-ynnx-dc", (Object[])new Object[0]), e);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String packFileName(String accNo, String JnlDate, String JnlTime, String DCFlag, String Amount, String Balance, Map<String, Integer> countMap) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(accNo).append("_");
        fileName.append(JnlDate).append("_");
        fileName.append(JnlTime.replace(":", "")).append("_");
        fileName.append(DCFlag).append("_");
        fileName.append(Amount).append("_");
        fileName.append(Balance);
        if (countMap.containsKey(fileName.toString())) {
            int recount = countMap.get(fileName.toString());
            countMap.put(fileName.toString(), recount + 1);
            fileName.append("_").append(String.format("%04d", recount));
        } else {
            countMap.put(fileName.toString(), 0);
        }
        fileName.append(".pdf");
        return fileName.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return null;
    }
}

