/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.cus.util;

import java.time.LocalDateTime;
import java.util.List;
import kd.sdk.ebg.cus.bean.biz.payment.SDKPaymentInfo;
import kd.sdk.ebg.cus.enumeration.SDKPaymentState;
import kd.sdk.ebg.trd.util.StringUtils;

public class SDKPayStateUtil {
    public static final String SYSTEM = "system";
    public static final String PAY_FAIL = "payFail";

    public static void setPaymentState(SDKPaymentInfo paymentInfo, SDKPaymentState state, String bankStatus, String bankMsg) {
        paymentInfo.setBackStatus(paymentInfo.getStatus());
        paymentInfo.setBackStatusMsg(paymentInfo.getStatusMsg());
        paymentInfo.setUpdateOperation(SYSTEM);
        LocalDateTime updateTime = LocalDateTime.now();
        if (state != null) {
            paymentInfo.setStatus(state.getId());
            paymentInfo.setStatusName(state.getEnName());
            paymentInfo.setStatusMsg(state.getCnName());
            paymentInfo.setUpdateTime(updateTime);
            if (!StringUtils.isEmpty(bankStatus)) {
                paymentInfo.setBankStatus(bankStatus);
            }
            if (!StringUtils.isEmpty(bankMsg)) {
                paymentInfo.setBankMsg(bankMsg);
            }
        }
    }

    public static void setPaymentState(List<SDKPaymentInfo> paymentInfoList, SDKPaymentState state, String bankStatus, String bankMsg) {
        for (SDKPaymentInfo paymentInfo : paymentInfoList) {
            SDKPayStateUtil.setPaymentState(paymentInfo, state, bankStatus, bankMsg);
        }
    }

    public static void setCommitPaymentFail(SDKPaymentInfo paymentInfo, String bankStatus, String bankMsg) {
        SDKPayStateUtil.setPaymentState(paymentInfo, SDKPaymentState.FAIL, bankStatus, bankMsg);
        paymentInfo.setUpdateOperation(PAY_FAIL);
    }

    public static void setCommitPaymentFail(List<SDKPaymentInfo> paymentInfoList, String bankStatus, String bankMsg) {
        for (SDKPaymentInfo paymentInfo : paymentInfoList) {
            SDKPayStateUtil.setPaymentState(paymentInfo, SDKPaymentState.FAIL, bankStatus, bankMsg);
            paymentInfo.setUpdateOperation(PAY_FAIL);
        }
    }
}

