/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.trd.banks.pab.opa;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.cert.X509Cert;
import kd.sdk.ebg.trd.exception.SDKException;

public class SDKX509Cert {
    private X509Cert x509Cert;

    public SDKX509Cert(X509Cert x509Cert) {
        this.x509Cert = x509Cert;
    }

    public X509Cert getX509Cert() {
        return this.x509Cert;
    }

    public void setX509Cert(X509Cert x509Cert) {
        this.x509Cert = x509Cert;
    }

    public String getSubject() {
        return this.x509Cert.getSubject();
    }

    public byte[] getEncoded() throws SDKException {
        try {
            return this.x509Cert.getEncoded();
        }
        catch (PKIException e) {
            throw new SDKException("PKIException", e);
        }
    }

    public static X509Cert[] getX509Certs(SDKX509Cert[] caCerts) {
        X509Cert[] x509Certs = new X509Cert[]{};
        if (caCerts != null && caCerts.length > 0) {
            x509Certs = new X509Cert[caCerts.length];
            for (int i = 0; i < caCerts.length; ++i) {
                x509Certs[i] = caCerts[i].getX509Cert();
            }
        }
        return x509Certs;
    }

    public static SDKX509Cert[] getSDKX509Certs(X509Cert[] certs) {
        SDKX509Cert[] x509Certs = new SDKX509Cert[]{};
        if (certs != null && certs.length > 0) {
            x509Certs = new SDKX509Cert[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509Certs[i] = new SDKX509Cert(certs[i]);
            }
        }
        return x509Certs;
    }
}

