/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.ebg.trd.jdom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import kd.sdk.ebg.trd.exception.SDKException;
import kd.sdk.ebg.trd.jdom.SDKElement;
import kd.sdk.ebg.trd.util.StringUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class SDKElementUtil {
    public static SDKElement addChild(SDKElement parent, String childName) throws SDKException {
        SDKElement child = new SDKElement(childName);
        if (parent.getElement() == null) {
            throw new SDKException("pgpSecKey is null");
        }
        parent.getElement().addContent((Content)child.getElement());
        return child;
    }

    public static SDKElement addChild(SDKElement parent, String childName, String childValue) {
        SDKElement child = new SDKElement(childName);
        child.getElement().setText(childValue == null ? "" : childValue);
        parent.getElement().addContent((Content)child.getElement());
        return child;
    }

    public static String root2String(SDKElement root, String encoding) throws SDKException {
        return SDKElementUtil.root2String(root.getElement(), encoding, false);
    }

    private static String root2String(Element root, String encoding, boolean formated) throws SDKException {
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setIndent("    ");
        newFormat.setExpandEmptyElements(true);
        outputter.setFormat(newFormat);
        Document document = null;
        try {
            int index;
            if (root.getParent() != null) {
                root.detach();
            }
            document = new Document(root);
            String str = outputter.outputString(document);
            while (str.endsWith("\r\n")) {
                index = str.lastIndexOf("\r\n");
                str = str.substring(0, index);
            }
            while (str.endsWith("\n")) {
                index = str.lastIndexOf("\n");
                str = str.substring(0, index);
            }
            return str;
        }
        catch (Throwable t) {
            throw new SDKException("jdom", t);
        }
    }

    public static SDKElement string2Root(String content, String encoding) throws SDKException {
        Document document = SDKElementUtil.string2Document(content, encoding);
        Element root = document.getRootElement();
        SDKElement sdkElement = new SDKElement();
        sdkElement.setElement(root);
        return sdkElement;
    }

    public static Document string2Document(String contentStr, String encoding) throws SDKException {
        Document var19;
        String xmlHead;
        int i;
        if (StringUtils.isEmpty(contentStr)) {
            throw new SDKException("xml content is empty");
        }
        String content = SDKElementUtil.copyStr(contentStr);
        int startPoint = (content = SDKElementUtil.filterMsg(content)).indexOf("<?xml");
        if (-1 != startPoint) {
            content = content.substring(startPoint);
        }
        if (-1 == content.indexOf("<?xml")) {
            content = "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>" + content;
        }
        if (-1 == (i = (xmlHead = content.substring(0, content.indexOf("?>") + 2).toLowerCase(Locale.ENGLISH)).indexOf(encoding.toLowerCase(Locale.ENGLISH)))) {
            content = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + content.substring(content.indexOf("?>") + 2);
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(content.getBytes(encoding));
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            var19 = builder.build((InputStream)bais);
        }
        catch (Exception e) {
            throw new SDKException("xml content error", e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
        return var19;
    }

    private static String copyStr(String content) {
        if (content == null) {
            return "";
        }
        char[] charArrays = content.toCharArray();
        return String.copyValueOf(charArrays);
    }

    private static String filterMsg(String content) {
        content = content.replaceAll("&nbsp;", "");
        content = content.replaceAll("&(?!amp)", "&amp;");
        return content;
    }

    public static SDKElement getChild(SDKElement parent, String name) throws SDKException {
        if (parent.getElement() == null) {
            throw new SDKException("Element is empty");
        }
        Element child = parent.getElement().getChild(name);
        SDKElement sdkElement = new SDKElement();
        sdkElement.setElement(child);
        return sdkElement;
    }

    public static String getChildTextTrim(SDKElement parent, String name) throws SDKException {
        if (parent.getElement() == null) {
            throw new SDKException("Element is empty");
        }
        return parent.getElement().getChildTextTrim(name);
    }
}

