/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.gcpmanage;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.gcpmanage.GcpApiBuilder;
import kd.imsc.cc.business.gcpmanage.TypeEnum;
import kd.imsc.cc.business.helper.DataOfferHelper;
import kd.imsc.cc.business.iprm.gcpapi.AbstractGcpBridgeManager;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.utils.OkHttpUtils;

public class GcpTokenManager
extends AbstractGcpBridgeManager<TypeEnum> {
    private static final Log logger = LogFactory.getLog(GcpTokenManager.class);

    private static Map<String, Object> getSysSetting() {
        return DataOfferHelper.getGcpConfigInfo();
    }

    private static GcpApiBuilder getBuilder() {
        Map<String, Object> param = GcpTokenManager.getSysSetting();
        return new GcpApiBuilder(param);
    }

    @Override
    public BizOperationResult baseGcpRequestByGet(Map<String, Object> params, TypeEnum typeEnum) {
        long startTime = System.currentTimeMillis();
        long gcpTime = 0L;
        BizOperationResult result = new BizOperationResult(false);
        try {
            String tenantInfo;
            GcpApiBuilder gcpApiBuilder = GcpTokenManager.getBuilder();
            String url = gcpApiBuilder.getFullUrl(typeEnum);
            params.putAll(this.baseReqParams());
            StringBuilder builder = new StringBuilder(url);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.append(String.format("&%s=%s", entry.getKey(), entry.getValue()));
            }
            if (typeEnum.isRecTenant() && StringUtils.isNotEmpty((String)(tenantInfo = this.recordTenantInfo()))) {
                builder.append(String.format("&%s=%s", "rec_tenant", tenantInfo));
            }
            url = builder.toString();
            logger.info("Http get|Url\uff1a{}", (Object)url);
            long gcpStartTime = System.currentTimeMillis();
            String resultPost = OkHttpUtils.getRequest(url);
            gcpTime = System.currentTimeMillis() - gcpStartTime;
            this.parseHttpResp(resultPost, result, url);
        }
        catch (Exception ex) {
            logger.error(typeEnum.getName(), (Throwable)ex);
            result.setErrorCode(99);
            result.setErrorDesc(String.format("%1$s %2$s", typeEnum.getName(), ex.getMessage()));
        }
        logger.info("{}|gcp\u529f\u80fd\u8bf7\u6c42\u8017\u65f6\uff1a{}ms|\u603b\u8017\u65f6\uff1a{}ms", new Object[]{typeEnum.getPath(), gcpTime, System.currentTimeMillis() - startTime});
        logger.info("Gcp request finish");
        return result;
    }

    @Override
    public BizOperationResult baseGcpRequestByPostJson(Map<String, Object> params, TypeEnum typeEnum) {
        long startTime = System.currentTimeMillis();
        long gcpTime = 0L;
        BizOperationResult result = new BizOperationResult(false);
        try {
            String tenantInfo;
            GcpApiBuilder gcpApiBuilder = GcpTokenManager.getBuilder();
            String url = gcpApiBuilder.getFullUrl(typeEnum);
            Map<String, String> baseParamMap = this.baseReqParams();
            params.put("base", baseParamMap);
            if (typeEnum.isRecTenant() && StringUtils.isNotEmpty((String)(tenantInfo = this.recordTenantInfo()))) {
                baseParamMap.put("rec_tenant", tenantInfo);
            }
            logger.info("Http Post|Url\uff1a{}|header\uff1a{}|parameter {}", new Object[]{url, null, OpenJsonUtil.toJson(params)});
            long gcpStartTime = System.currentTimeMillis();
            String resultPost = OkHttpUtils.postJsonRequest(url, null, JSONObject.toJSONString(params));
            gcpTime = System.currentTimeMillis() - gcpStartTime;
            this.parseHttpResp(resultPost, result, url);
        }
        catch (Exception ex) {
            logger.error(typeEnum.getName(), (Throwable)ex);
            result.setErrorCode(99);
            result.setErrorDesc(String.format("%1$s,%2$s", typeEnum.getName(), ex.getMessage()));
        }
        logger.info("{}|gcp\u529f\u80fd\u8bf7\u6c42\u8017\u65f6\uff1a{}ms|\u603b\u8017\u65f6\uff1a{}ms", new Object[]{typeEnum.getPath(), gcpTime, System.currentTimeMillis() - startTime});
        logger.info("Gcp request finish");
        return result;
    }
}

