/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.report.ReportShowParameter;

public class FormOpenHelper {
    private static final String APP_MIAN_TAB = "appmiantab";
    private static final String CTRL_SUBMAINTAB = "_submaintab_";
    private static final String BOS_LIST = "bos_list";
    private static Map<String, Class<?>> ptypes = new HashMap();

    public static void showList(AbstractFormPlugin form, String entity) {
        FormOpenHelper.openBillList(form, entity, Collections.emptyList());
    }

    public static void openBillList(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        FormOpenHelper.openBillList(form, entity, filters, null);
    }

    public static void openBillList(AbstractFormPlugin form, String entity, List<QFilter> filters, String caption) {
        if (form == null || StringUtils.isEmpty((CharSequence)entity)) {
            return;
        }
        if (FormOpenHelper.openTabIfExist(form, entity, filters)) {
            return;
        }
        ListShowParameter param = FormOpenHelper.getListShowParameter(entity, filters);
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            param.setCaption(caption);
        }
        form.getView().showForm((FormShowParameter)param);
    }

    private static ListShowParameter getListShowParameter(String entity, List<QFilter> filters) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
        param.setFormId(formConfig.getListFormId());
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return param;
    }

    private static boolean openTabIfExist(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        IFormView view = form.getView();
        IFormView mainView = view.getMainView();
        if (mainView != null && !mainView.getPageId().equals(view.getPageId())) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId());
            if (appView == null) {
                return false;
            }
            Control control = appView.getControl(CTRL_SUBMAINTAB);
            return control instanceof Tab && FormOpenHelper.existTabPage(entity, view, appView, (Tab)control, filters);
        }
        return false;
    }

    private static boolean existTabPage(String entity, IFormView view, IFormView appView, Tab control, List<QFilter> filters) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || APP_MIAN_TAB.equals(tabPageKey) || !((formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter)) continue;
            ListShowParameter parameter = (ListShowParameter)formShowParameter;
            String formId = parameter.getBillFormId();
            if (filters == null || !entity.equals(formId)) continue;
            boolean flag = true;
            boolean flush = false;
            ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
            if (listFilterParameter == null) continue;
            List qFilters = listFilterParameter.getQFilters();
            if (filters.size() != qFilters.size()) continue;
            block1: for (int i = 0; i < qFilters.size(); ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                QFilter filter = filters.get(i);
                boolean property = qFilter.getProperty().equals(filter.getProperty());
                boolean cp = qFilter.getCP().equals(filter.getCP());
                if (property && cp) {
                    Object value = qFilter.getValue();
                    Object value1 = filter.getValue();
                    if (value instanceof List && value1 instanceof List) {
                        List val = (List)value;
                        List val1 = (List)value1;
                        for (int i1 = 0; i1 < val.size(); ++i1) {
                            if (val1.size() > 0 && val.get(i1).equals(val1.get(i1))) continue;
                            flag = false;
                            continue block1;
                        }
                        continue;
                    }
                    if (value instanceof Long && value1 instanceof Long) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    if (value instanceof String && value1 instanceof String) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    if (value instanceof Integer && value1 instanceof Integer) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    flag = false;
                    break;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            if (flush) {
                lv.invokeOperation("refresh");
            }
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    static {
        ptypes.put("form", FormShowParameter.class);
        ptypes.put("report", ReportShowParameter.class);
        ptypes.put("bill", BillShowParameter.class);
        ptypes.put("base", BaseShowParameter.class);
        ptypes.put("list", ListShowParameter.class);
        ptypes.put("parameter", ParameterShowParameter.class);
        ptypes.put("mobilebase", MobileBaseShowParameter.class);
        ptypes.put("mobilebill", MobileBillShowParameter.class);
        ptypes.put("mobileform", MobileFormShowParameter.class);
        ptypes.put("mobilelist", MobileListShowParameter.class);
        ptypes.put("mobiletreelist", MobileListShowParameter.class);
    }
}

