/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.imsc.cc.common.entity.DataPackageModifyConfig;

public class LoadPackageHelper {
    private static final Log logger = LogFactory.getLog(LoadPackageHelper.class);
    private static final String ENTRY_FIELD_SEQ = "seq";
    private static final String ENTRY_FIELD_SOURCE_OBJECT = "sourceobject";
    private static final String ENTRY_FIELD_BILL_NAME = "billname";
    private static final String ENTRY_FIELD_BUSINESS_OBJECT_TYPE = "businessobjecttype";
    private static final String TARGET_FORM_ID = "target_formId";
    private static final String NEW_DATA_NUMBER = "new_data_number";
    private static final String ENTRY_SOURCE_NAME = "sourcename";

    public static String getDependencyTip(DynamicObjectCollection dynamicObjects, int[] rows) {
        if (null == dynamicObjects || dynamicObjects.isEmpty() || null == rows || rows.length == 0) {
            return null;
        }
        HashMap<String, List> allBusinessObjMap = new HashMap<String, List>(dynamicObjects.size());
        HashMap<String, List> selectBusinessObjMap = new HashMap<String, List>(rows.length);
        List<String> ignoreBusinessList = Arrays.asList("bos_user", "bos_org");
        HashSet<String> needCheckBusinessList = new HashSet<String>(8);
        HashMap<String, Set<DynamicObject>> noChooseReplaceBusinessMap = new HashMap<String, Set<DynamicObject>>(8);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String number = dynamicObject.getString(ENTRY_FIELD_BILL_NAME);
            List allBusinessObjList = allBusinessObjMap.getOrDefault(number, new ArrayList(1));
            allBusinessObjList.add(dynamicObject);
            allBusinessObjMap.put(number, allBusinessObjList);
            if (!ArrayUtils.contains((int[])rows, (int)index++)) continue;
            List selectBusinessObjList = selectBusinessObjMap.getOrDefault(number, new ArrayList(1));
            selectBusinessObjList.add(dynamicObject);
            selectBusinessObjMap.put(number, selectBusinessObjList);
            DataPackageModifyConfig dataPackageModifyConfig = (DataPackageModifyConfig)SerializationUtils.fromJsonString((String)dynamicObject.get(ENTRY_FIELD_SOURCE_OBJECT).toString(), DataPackageModifyConfig.class);
            Map<String, JSONObject> replaceRegMap = dataPackageModifyConfig.getReplaceRegMap();
            if (null == replaceRegMap) continue;
            Set<Map.Entry<String, JSONObject>> replaceRegMapEntries = replaceRegMap.entrySet();
            for (Map.Entry<String, JSONObject> replaceRegMapEntry : replaceRegMapEntries) {
                String replaceFormId;
                JSONObject replaceRegValue = replaceRegMapEntry.getValue();
                if (null == replaceRegValue || StringUtils.isBlank((CharSequence)(replaceFormId = replaceRegValue.getString(TARGET_FORM_ID))) || ignoreBusinessList.contains(replaceFormId)) continue;
                needCheckBusinessList.add(replaceFormId);
                if (replaceRegValue.containsKey((Object)NEW_DATA_NUMBER)) continue;
                Set noChooseReplaceBusinessList = noChooseReplaceBusinessMap.getOrDefault(replaceFormId, new HashSet(8));
                noChooseReplaceBusinessList.add(dynamicObject);
                noChooseReplaceBusinessMap.put(replaceFormId, noChooseReplaceBusinessList);
            }
        }
        logger.info("\u5df2\u9009\u62e9\u52a0\u8f7d\u5bf9\u8c61\u9700\u68c0\u67e5\u7684\u4f9d\u8d56\u9879\uff1a{}", needCheckBusinessList);
        if (CollectionUtils.isEmpty(needCheckBusinessList)) {
            return null;
        }
        ArrayList<String> needTipList = new ArrayList<String>(allBusinessObjMap.size());
        ArrayList<String> needTipReplaceList = new ArrayList<String>(allBusinessObjMap.size());
        for (String needCheckBusiness : needCheckBusinessList) {
            if (!allBusinessObjMap.containsKey(needCheckBusiness)) {
                LoadPackageHelper.addNeedTipReplaceList(needCheckBusiness, noChooseReplaceBusinessMap, needTipReplaceList);
                continue;
            }
            if (selectBusinessObjMap.containsKey(needCheckBusiness) && ((List)selectBusinessObjMap.get(needCheckBusiness)).size() == ((List)allBusinessObjMap.get(needCheckBusiness)).size()) continue;
            List dynamicObjectList = (List)allBusinessObjMap.get(needCheckBusiness);
            List<String> selectFileNameList = LoadPackageHelper.getFileNameList((List)selectBusinessObjMap.get(needCheckBusiness));
            for (DynamicObject dynamicObject : dynamicObjectList) {
                if (selectFileNameList.contains(dynamicObject.getString(ENTRY_SOURCE_NAME))) continue;
                String tipInfo = dynamicObject.get(ENTRY_FIELD_SEQ) + "\u3001" + dynamicObject.getString(ENTRY_FIELD_BUSINESS_OBJECT_TYPE);
                needTipList.add(tipInfo);
            }
        }
        if (CollectionUtils.isNotEmpty(needTipList)) {
            needTipList.sort(String::compareTo);
            return LoadPackageHelper.getCheckDependTipHintMsg(needTipList);
        }
        if (CollectionUtils.isNotEmpty(needTipReplaceList)) {
            needTipReplaceList.sort(String::compareTo);
            return LoadPackageHelper.getReplaceTipHintMsg(needTipReplaceList);
        }
        return null;
    }

    private static void addNeedTipReplaceList(String needCheckBusiness, Map<String, Set<DynamicObject>> noChooseReplaceBusinessMap, List<String> needTipReplaceList) {
        if (noChooseReplaceBusinessMap.containsKey(needCheckBusiness)) {
            Set<DynamicObject> noChooseReplaceBusinessList = noChooseReplaceBusinessMap.get(needCheckBusiness);
            for (DynamicObject noChooseReplaceBusiness : noChooseReplaceBusinessList) {
                String tipInfo = noChooseReplaceBusiness.get(ENTRY_FIELD_SEQ) + "\u3001" + noChooseReplaceBusiness.getString(ENTRY_FIELD_BUSINESS_OBJECT_TYPE);
                if (needTipReplaceList.contains(tipInfo)) continue;
                needTipReplaceList.add(tipInfo);
            }
        }
    }

    private static List<String> getFileNameList(List<DynamicObject> businessObjList) {
        if (CollectionUtils.isEmpty(businessObjList)) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> list = new ArrayList<String>(businessObjList.size());
        for (DynamicObject dynamicObject : businessObjList) {
            list.add(dynamicObject.getString(ENTRY_SOURCE_NAME));
        }
        return list;
    }

    public static String getCheckDependTitle() {
        return ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"LoadPackageHelper_0", (String)"imsc-iprm-business", (Object[])new Object[0]);
    }

    private static String getCheckDependTipHintMsg(List<String> needTipList) {
        StringBuilder hintMsgBuilder = new StringBuilder();
        hintMsgBuilder.append(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u672c\u6b21\u52a0\u8f7d\u4f9d\u8d56\u4ee5\u4e0b\u4e1a\u52a1\u5bf9\u8c61\uff0c\u53ef\u80fd\u56e0\u7f3a\u5c11\u6570\u636e\u800c\u52a0\u8f7d\u5931\u8d25\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"LoadPackageHelper_1", (String)"imsc-iprm-business", (Object[])new Object[0]));
        for (String tip : needTipList) {
            hintMsgBuilder.append("\r\n");
            hintMsgBuilder.append(tip);
        }
        return hintMsgBuilder.toString();
    }

    private static String getReplaceTipHintMsg(List<String> needTipList) {
        StringBuilder hintMsgBuilder = new StringBuilder();
        hintMsgBuilder.append(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u672c\u6b21\u52a0\u8f7d\u4ee5\u4e0b\u4e1a\u52a1\u5bf9\u8c61\u9700\u8981\u505a\u66ff\u6362\u5173\u952e\u503c\uff0c\u5426\u5219\u53ef\u80fd\u52a0\u8f7d\u5931\u8d25\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"LoadPackageHelper_2", (String)"imsc-iprm-business", (Object[])new Object[0]));
        for (String tip : needTipList) {
            hintMsgBuilder.append("\r\n");
            hintMsgBuilder.append(tip);
        }
        return hintMsgBuilder.toString();
    }
}

