/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dbversion.VersionCaptionInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityMetadataProvider;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class PermissionHelper {
    private static final Log logger = LogFactory.getLog(PermissionHelper.class);
    private static final String PERMISSION = "permission";
    private static final String COSMIC = "cosmic_bos";
    private static final String KD = "kingdee";
    private static final String STARRY = "starry";

    public static boolean hasImportPermission(String entityNumber) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        if (ops == null) {
            return false;
        }
        for (Map op : ops) {
            String opType;
            Object type = op.get("type");
            if (type == null || !"importdata".equals(opType = (String)type)) continue;
            if (!op.containsKey(PERMISSION)) {
                return true;
            }
            String permission = (String)op.get(PERMISSION);
            if (StringUtils.isEmpty((String)permission)) {
                return true;
            }
            return PermissionHelper.checkPagePermission(entityNumber, permission);
        }
        return false;
    }

    private static boolean checkPagePermission(String pageNumber, String permissionItemId) {
        int flag = PermissionServiceHelper.checkPermission((long)UserServiceHelper.getCurrentUserId(), (String)"bos_org", (long)0L, (String)null, (String)pageNumber, (String)permissionItemId);
        return flag == 1;
    }

    public static Tuple<Boolean, String> checkPermissions(long userId, String appId, String entityNumber, String entityName, String ... permissionItems) {
        Map permMap = PermissionServiceHelper.checkMultiPermItemInfos((long)userId, (String)appId, (String)entityNumber, Arrays.stream(permissionItems).collect(Collectors.toSet()));
        HashSet noPermissionItems = new HashSet(permissionItems.length);
        for (Map.Entry permEntry : permMap.entrySet()) {
            Boolean hashPermission = (Boolean)permEntry.getValue();
            if (!Boolean.FALSE.equals(hashPermission)) continue;
            noPermissionItems.add(permEntry.getKey());
        }
        if (!noPermissionItems.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", noPermissionItems);
            DynamicObjectCollection permItems = QueryServiceHelper.query((String)"perm_permitem", (String)"name", (QFilter[])qFilter.toArray());
            String permName = permItems.stream().map(p -> p.getString("name")).collect(Collectors.joining(","));
            String noPermTips = ResManager.loadKDString((String)"\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PermissionHelper_0", (String)"imsc-cc", (Object[])new Object[0]);
            return Tuple.create((Object)false, (Object)String.format(noPermTips, entityName, permName));
        }
        return Tuple.create((Object)true, null);
    }

    public static String getKdCosmicVersion() {
        IndustryVersionInfo versionInfo = IndustryVersionServiceHelper.getVersion((String)COSMIC, (String)KD);
        if (versionInfo == null) {
            return null;
        }
        return versionInfo.getVersion();
    }

    public static String getKdStarryVersion() {
        List captionList = IndustryVersionServiceHelper.getCaption((String)KD, (String)STARRY);
        if (captionList == null || captionList.isEmpty()) {
            return null;
        }
        List galaxyVersions = captionList.stream().filter(v -> StringUtils.isNotEmpty((String)v.getProductNumber()) && v.getProductNumber().startsWith("galaxy")).collect(Collectors.toList());
        if (galaxyVersions == null || galaxyVersions.isEmpty()) {
            return null;
        }
        IndustryVersionInfo galaxyVersion = galaxyVersions.stream().max(Comparator.comparing(IndustryVersionInfo::getVersion)).get();
        List verCaption = galaxyVersion.getVerCaption();
        if (CollectionUtils.isEmpty((Collection)verCaption)) {
            return null;
        }
        return ((VersionCaptionInfo)verCaption.get(0)).getCaption();
    }

    public static String getIsv() {
        IndustryVersionInfo versionInfo = IndustryVersionServiceHelper.getVersion((String)COSMIC, (String)KD);
        if (versionInfo == null) {
            return null;
        }
        return versionInfo.getIsv();
    }

    public static final Map<String, String> getMetaDisplayName(String formId, Set<String> fieldSet) {
        if (StringUtils.isEmpty((String)formId) || fieldSet == null || fieldSet.isEmpty()) {
            return null;
        }
        MainEntityType dt = null;
        try {
            EntityMetadataProvider provider = new EntityMetadataProvider();
            dt = provider.getDataEntityType(formId);
        }
        catch (KDException e) {
            logger.error("PermissionHelper getMetaDisplayName error. formId : {}", (Object)formId);
        }
        if (ObjectUtils.isEmpty((Object)dt)) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        if (dataEntityType == null) {
            return null;
        }
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        for (String field : fieldSet) {
            try {
                String newField = field.split("\\.")[0];
                String localeValue = ((IDataEntityProperty)dataEntityType.getFields().get(newField)).getDisplayName().getLocaleValue();
                fieldNameMap.put(field, localeValue);
            }
            catch (Exception exception) {}
        }
        return fieldNameMap;
    }
}

