/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imsc.cc.business.install.ISubPackageHandler;
import kd.imsc.cc.business.utils.IprmFileUtils;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;

public abstract class AbstractSubPackageHandler
implements ISubPackageHandler {
    private static final Log logger = LogFactory.getLog(AbstractSubPackageHandler.class);

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = new SubDataCheckResult();
        if (configInfo == null) {
            checkResult.setFail(ResManager.loadKDString((String)"\u5b50\u5305\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AbstractSubPackageHandler_0", (String)"imsc-cc", (Object[])new Object[0]));
            return checkResult;
        }
        logger.info("\u5f00\u59cb\u6570\u636e\u5305{}\u57fa\u7840\u68c0\u67e5\uff0c\u6570\u636e\u5305\u5b58\u653e\u6587\u4ef6\u5939\u8def\u5f84\u4e3a{}!", (Object)configInfo.getFileName(), (Object)configInfo.getFileDirectory());
        if (StringUtils.isEmpty((CharSequence)configInfo.getFileName())) {
            checkResult.setFail(ResManager.loadKDString((String)"\u5b50\u5305\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"AbstractSubPackageHandler_1", (String)"imsc-cc", (Object[])new Object[0]));
            return checkResult;
        }
        if (!IprmFileUtils.isFileExistWithFilePath(configInfo.getFileDirectory())) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u5b58\u653e\u8def\u5f84\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\u3002", (String)"AbstractSubPackageHandler_2", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        if (IprmFileUtils.isFileZipFormatWithFileName(configInfo.getFileName())) {
            if (IprmFileUtils.isFileDirectoryEmptyWithFilePath(configInfo.getFileDirectory())) {
                checkResult.setFail(String.format(ResManager.loadKDString((String)"\u89e3\u538b\u540e\u5b50\u5305\u201c%1$s\u201d\u6587\u4ef6\u5b58\u653e\u8def\u5f84\u4e3a\u7a7a\u3002", (String)"AbstractSubPackageHandler_3", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
                return checkResult;
            }
            if (this.isZipFileNeedUnzip()) {
                try {
                    this.unzipSubPackage(configInfo.getFileDirectory() + File.separator + configInfo.getFileName());
                }
                catch (IOException e) {
                    checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u89e3\u538b\u5931\u8d25\u3002", (String)"AbstractSubPackageHandler_4", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
                    return checkResult;
                }
            }
        } else {
            String subFilePath = configInfo.getFileDirectory() + File.separator + configInfo.getFileName();
            if (!IprmFileUtils.isFileExistWithFilePath(subFilePath)) {
                checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1s\u201d\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"AbstractSubPackageHandler_5", (String)"imsc-cc", (Object[])new Object[0]), subFilePath));
                return checkResult;
            }
        }
        if (configInfo.getInstallInfo() == null) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1s\u201d\u6ca1\u6709\u5177\u4f53\u5b89\u88c5\u914d\u7f6e\u6587\u4ef6\u3002", (String)"AbstractSubPackageHandler_6", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        SubDataInstallInfo installInfo = configInfo.getInstallInfo();
        if (StringUtils.isEmpty((CharSequence)installInfo.getFormId())) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1s\u201d\u672a\u5b89\u88c5\u5230\u6307\u5b9a\u9875\u9762\u5355\u636e\u6807\u8bc6\u4e2d\u3002", (String)"AbstractSubPackageHandler_7", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        checkResult.setSuccess(true);
        return checkResult;
    }

    @Override
    public void subPackageDataModify(SubDataConfigureInfo configInfo, DataPackageModifyResult result) {
    }

    protected void unzipSubPackage(String filePath) throws IOException {
        IprmFileUtils.unzipPackage(new File(filePath));
    }

    protected boolean isModifySourceData(DataPackageModifyResult result) {
        if (result == null || !result.isInstall() || !result.isReplace()) {
            return false;
        }
        Map<String, Object> replaceRegMap = result.getReplaceRegMap();
        return replaceRegMap != null && !replaceRegMap.isEmpty();
    }
}

