/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.imsc.cc.common.exception.KdXkIprmException;

public class FileUploadTask
implements Callable<String> {
    private String appId;
    private String formId;
    private String fileName;
    private File uploadFile;

    public FileUploadTask(String appId, String formId, String fileName, File uploadFile) {
        this.appId = appId;
        this.formId = formId;
        this.fileName = fileName;
        this.uploadFile = uploadFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String call() throws KdXkIprmException {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (FileInputStream in = new FileInputStream(this.uploadFile);){
            String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)this.appId, (String)this.formId, (Object)uuid, (String)this.replaceSpeSymbol(this.fileName));
            FileItem fi = new FileItem(this.fileName, path, (InputStream)in);
            String string = fileService.upload(fi);
            return string;
        }
        catch (Exception e) {
            String msgTpl = String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 exception %2$s", (String)"FileUploadTask_0", (String)"imsc-cc", (Object[])new Object[0]), this.fileName, e.getClass().getName());
            throw new KdXkIprmException(msgTpl, e, 2001);
        }
    }

    private String replaceSpeSymbol(String str) {
        for (int i = 0; i < AttachmentServiceHelper.SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(AttachmentServiceHelper.SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(AttachmentServiceHelper.SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }
}

