/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.excel;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class ExcelSheetHandler {
    private static final Log LOGGER = LogFactory.getLog(ExcelSheetHandler.class);
    private Map<String, Object> entryMap;
    protected Map<String, Integer> colIndex;

    public ExcelSheetHandler(Map<String, Object> entryMap) {
        this.entryMap = entryMap;
    }

    public void init(XSSFRow row) {
        if (row == null || this.entryMap == null || this.entryMap.isEmpty()) {
            return;
        }
        Iterator cellIterator = row.cellIterator();
        if (cellIterator == null) {
            return;
        }
        this.colIndex = new HashMap<String, Integer>(this.entryMap.size());
        while (cellIterator.hasNext()) {
            String key;
            int indexOf;
            Cell cell = (Cell)cellIterator.next();
            String cellValue = cell.getStringCellValue();
            if (this.entryMap.containsKey(cellValue)) {
                this.colIndex.put(cellValue, cell.getColumnIndex());
            }
            if ((indexOf = cellValue.indexOf(46)) < 0 || !this.entryMap.containsKey(key = cellValue.substring(0, indexOf))) continue;
            this.colIndex.put(cellValue, cell.getColumnIndex());
        }
    }

    public void modify(XSSFRow row) {
        if (row == null || this.entryMap == null || this.entryMap.isEmpty() || this.colIndex == null || this.colIndex.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, Integer>> entrySet = this.colIndex.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            JSONArray fieldArray;
            Object field;
            Map modifyObj;
            Object newDataObj;
            String newKey;
            String key = entry.getKey();
            Integer index = entry.getValue();
            Object o = this.entryMap.get(key);
            int indexOf = key.indexOf(46);
            if ((o == null || !(o instanceof Map)) && (indexOf < 0 || (o = this.entryMap.get(newKey = key.substring(0, indexOf))) == null || !(o instanceof Map)) || (newDataObj = (modifyObj = (Map)o).get("new_data")) == null || !(newDataObj instanceof DynamicObject) || (field = modifyObj.get("fields")) == null || !(field instanceof JSONArray) || (fieldArray = (JSONArray)field).isEmpty()) continue;
            String newField = key;
            if (indexOf >= 0) {
                newField = key.substring(indexOf + 1);
            }
            DynamicObject newDyObj = (DynamicObject)newDataObj;
            String newValue = newDyObj.get(newField).toString();
            XSSFCell cell1 = row.getCell(index.intValue());
            if (cell1 == null) continue;
            row.removeCell((Cell)cell1);
            XSSFCell cell = row.createCell(index.intValue(), CellType.STRING);
            cell.setCellValue(newValue);
        }
    }
}

