/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.cc.common.exception.KdXkIprmException;

public class JsonDynamicConvertHelper {
    private static final String SCH_JOB = "sch_job";
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String CONTENT = "content";
    private static final String ALL_PRO_LIST = "allProList";
    private static final String DATE_LIST = "dateList";
    private static final String DECIMAL_LIST = "decimalList";
    private static final String BOOLEAN_LIST = "booleanList";
    private static final String ENTRY_LIST = "entryList";
    private static final String NUMBER_FIELD = "numberField";

    public static Map<String, DynamicObject> loadDyObjToMap(String entityName, String keyFields, JSONObject dataMap, List<Object> ids) {
        HashMap<String, DynamicObject> idsMap = new HashMap<String, DynamicObject>(4);
        if (StringUtils.isEmpty((CharSequence)entityName) || StringUtils.isEmpty((CharSequence)keyFields) || dataMap == null || dataMap.isEmpty() || ids == null || ids.isEmpty()) {
            return idsMap;
        }
        HashSet<String> keyFieldsSet = new HashSet<String>(Arrays.asList(keyFields.trim().replaceFirst(",", "").split(",")));
        Set<IDataEntityProperty> queryKeyProps = JsonDynamicConvertHelper.getQueryKeyProps(entityName, keyFieldsSet);
        QFilter filter = JsonDynamicConvertHelper.getKeyFieldFilter(dataMap, ids, queryKeyProps);
        if (filter == null) {
            return idsMap;
        }
        List pks = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filter.toArray(), null, (int)-1);
        if (pks == null || pks.isEmpty()) {
            return idsMap;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        if (dynamicObjects == null) {
            return idsMap;
        }
        for (DynamicObject dy : dynamicObjects) {
            idsMap.put(dy.getString("id"), dy);
        }
        return idsMap;
    }

    private static Set<IDataEntityProperty> getQueryKeyProps(String entityName, Set<String> keyFieldsSet) {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        HashSet<IDataEntityProperty> queryKeyProps = new HashSet<IDataEntityProperty>(4);
        for (IDataEntityProperty property : properties) {
            for (String keyField : keyFieldsSet) {
                if (!property.getName().equals(keyField)) continue;
                queryKeyProps.add(property);
            }
        }
        return queryKeyProps;
    }

    private static QFilter getKeyFieldFilter(JSONObject dataMap, List<Object> ids, Set<IDataEntityProperty> queryKeyProps) {
        QFilter filter = null;
        for (IDataEntityProperty prop : queryKeyProps) {
            HashSet<Object> valueSet = new HashSet<Object>(4);
            for (Object id : ids) {
                Object keyFieldValue = JsonDynamicConvertHelper.getPropValueFromDataMap(id, prop, dataMap);
                valueSet.add(keyFieldValue);
            }
            String propName = prop.getName();
            if (prop instanceof BasedataProp) {
                propName = prop.getName() + ".number";
            }
            if (filter == null) {
                filter = new QFilter(propName, "in", valueSet);
                continue;
            }
            filter.and(new QFilter(propName, "in", valueSet));
        }
        return filter;
    }

    private static Object getPropValueFromDataMap(Object id, IDataEntityProperty prop, JSONObject dataMap) {
        String name = prop.getName();
        JSONObject dyObj = dataMap.getJSONObject(id.toString());
        JSONObject bdObject = dyObj.getJSONObject("bd");
        JSONObject dataObject = dyObj.getJSONObject("data");
        Object keyFiledValue = prop instanceof MuliLangTextProp ? dataObject.getJSONObject(name).get((Object)"zh_CN") : (prop instanceof BasedataProp ? bdObject.getJSONArray(name).get(3) : dataObject.get((Object)name));
        return keyFiledValue;
    }

    public static void map2DynamicObject(DynamicObject currentObj, int op, Map<String, Object> allDataMap, int compareTo) throws KdXkIprmException {
        if (currentObj == null || allDataMap == null) {
            return;
        }
        Map billMap = (Map)allDataMap.get("data");
        if (billMap == null) {
            return;
        }
        Map<String, List<String>> differProMap = JsonDynamicConvertHelper.getDifferDynamicProperties(currentObj);
        List<String> allProList = differProMap.get(ALL_PRO_LIST);
        List<String> dateList = differProMap.get(DATE_LIST);
        List<String> decimalList = differProMap.get(DECIMAL_LIST);
        List<String> booleanList = differProMap.get(BOOLEAN_LIST);
        List<String> entryList = differProMap.get(ENTRY_LIST);
        String specialProperties = "id,seq,masterid,entryid,detailid,creator,createtime,modifier,modifytime,auditor,audittime";
        for (Map.Entry entry : billMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!allProList.contains(key)) continue;
            if (specialProperties.contains(key)) {
                if (op != 1 || !"createtime".equals(key)) continue;
                currentObj.set(key, (Object)new Date());
                continue;
            }
            if (dateList.contains(key)) {
                currentObj.set(key, (Object)new Date(Long.parseLong(entry.getValue().toString())));
                continue;
            }
            if (decimalList.contains(key)) {
                currentObj.set(key, (Object)JsonDynamicConvertHelper.obj2decimal(entry.getValue()));
                continue;
            }
            if (booleanList.contains(key)) {
                currentObj.set(key, (Object)(StringUtils.isEmpty((CharSequence)entry.getValue().toString()) ? Character.valueOf('0') : entry.getValue()));
                continue;
            }
            if (entryList.contains(key)) {
                JsonDynamicConvertHelper.map2Entry(currentObj, allDataMap, billMap, key, compareTo);
                continue;
            }
            currentObj.set(key, entry.getValue());
        }
    }

    public static DynamicObject setBdProperties(Map<String, Object> packetBdMap, DynamicObject currentObj, int op, int compareTo) throws KdXkIprmException {
        if (packetBdMap == null || currentObj == null) {
            return currentObj;
        }
        Map<String, Object> currentBdMap = JsonDynamicConvertHelper.getDynamicBdProperties(currentObj);
        String specialProperties = "id,masterid,entryid,detailid,creator,createtime,modifier,modifytime,auditor,audittime";
        for (Map.Entry<String, Object> propertyMap : packetBdMap.entrySet()) {
            String fieldName = propertyMap.getKey();
            if (!currentBdMap.containsKey(fieldName)) {
                throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5339\u914d\uff0c\u5b57\u6bb5\u201c%1$s\u201d\u5728\u5f53\u524d\u73af\u5883\u7684\u201c%2$s\u201d\uff08%3$s\uff09\u5b9e\u4f53\u4e0a\u4e0d\u5b58\u5728\u3002", (String)"JsonDynamicConvertHelper_0", (String)"imsc-cc", (Object[])new Object[0]), fieldName, currentObj.getDynamicObjectType().getDisplayName(), currentObj.getDataEntityType().getName()), 100001);
            }
            if (specialProperties.contains(fieldName)) {
                if (op != 1 || !"creator".equals(fieldName)) continue;
                currentObj.set(fieldName, (Object)RequestContext.get().getCurrUserId());
                continue;
            }
            if (currentBdMap.get(fieldName) instanceof BasedataProp) {
                String displayName = ((BasedataProp)currentBdMap.get(fieldName)).getDisplayName().getLocaleValue();
                List fieldInfo = (List)propertyMap.getValue();
                DynamicObject bd = JsonDynamicConvertHelper.getBdFromFilter((String)fieldInfo.get(0), (String)fieldInfo.get(1), fieldInfo.get(2), (String)fieldInfo.get(3), compareTo);
                if (bd == null) {
                    throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u201c%1$s\u201d\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"JsonDynamicConvertHelper_1", (String)"imsc-cc", (Object[])new Object[0]), displayName, fieldInfo.get(3)), 10001);
                }
                currentObj.set(fieldName, (Object)bd);
                continue;
            }
            Map bdValueMap = (Map)propertyMap.getValue();
            String entityName = (String)bdValueMap.get("type");
            String numberField = (String)bdValueMap.get(NUMBER_FIELD);
            JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
            DynamicObjectCollection basedatas = currentObj.getDynamicObjectCollection((IDataEntityProperty)currentBdMap.get(fieldName));
            basedatas.clear();
            for (int i = 0; i < arrays.size(); ++i) {
                JSONArray value = arrays.getJSONArray(i);
                DynamicObject bd = JsonDynamicConvertHelper.getBdFromFilter(entityName, numberField, value.getString(0), value.getString(1), compareTo);
                if (bd == null) {
                    throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"JsonDynamicConvertHelper_2", (String)"imsc-cc", (Object[])new Object[0]), value.getString(1), ((IDataEntityProperty)currentBdMap.get(fieldName)).getDisplayName()), 10001);
                }
                DynamicObject newRow = new DynamicObject(basedatas.getDynamicObjectType());
                newRow.set("fbasedataid", (Object)bd);
                basedatas.add((Object)newRow);
            }
        }
        return currentObj;
    }

    public static void specialFieldFill(DynamicObject currentObj) {
        if (currentObj == null) {
            return;
        }
        String entityName = currentObj.getDynamicObjectType().getName();
        if ("ism_interorgsettlerule".equals(entityName)) {
            if (!currentObj.getDynamicObjectCollection("entryentity").isEmpty()) {
                currentObj.set("currencysrc", ((DynamicObject)currentObj.getDynamicObjectCollection("entryentity").get(0)).get("currencysource"));
            }
        } else if ("bd_periodoutline_tree".equals(entityName)) {
            currentObj.set("periodyear1", currentObj.get("periodyear"));
        }
    }

    private static Map<String, List<String>> getDifferDynamicProperties(DynamicObject dynamicObject) {
        HashMap<String, List<String>> differProMap = new HashMap<String, List<String>>();
        ArrayList<String> allProList = new ArrayList<String>();
        ArrayList<String> bdList = new ArrayList<String>();
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<String> decimalList = new ArrayList<String>();
        ArrayList<String> booleanList = new ArrayList<String>();
        ArrayList<String> entryList = new ArrayList<String>();
        if (dynamicObject != null) {
            DataEntityPropertyCollection proptiesCol = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                if (iDataEntityProperty instanceof EntryProp) {
                    entryList.add(iDataEntityProperty.getName());
                }
                if (iDataEntityProperty instanceof MulBasedataProp) continue;
                if (!(iDataEntityProperty instanceof LongProp)) {
                    allProList.add(iDataEntityProperty.getName());
                }
                if (!(iDataEntityProperty instanceof DateProp)) {
                    if (iDataEntityProperty instanceof BasedataProp) {
                        bdList.add(iDataEntityProperty.getName());
                        continue;
                    }
                    if (iDataEntityProperty instanceof DecimalProp) {
                        decimalList.add(iDataEntityProperty.getName());
                        continue;
                    }
                    if (!(iDataEntityProperty instanceof BooleanProp)) continue;
                    booleanList.add(iDataEntityProperty.getName());
                    continue;
                }
                dateList.add(iDataEntityProperty.getName());
            }
        }
        differProMap.put(ALL_PRO_LIST, allProList);
        differProMap.put("bdList", bdList);
        differProMap.put(DATE_LIST, dateList);
        differProMap.put(DECIMAL_LIST, decimalList);
        differProMap.put(BOOLEAN_LIST, booleanList);
        differProMap.put(ENTRY_LIST, entryList);
        return differProMap;
    }

    private static BigDecimal obj2decimal(Object obj) {
        if (obj == null) {
            return new BigDecimal("0").abs();
        }
        String str = !StringUtils.isEmpty((CharSequence)obj.toString()) ? obj.toString().replace(",", "") : "0";
        return new BigDecimal(str).abs();
    }

    private static void map2SubEntry(DynamicObject currentObj, Map<String, Object> allData, List<Map<String, Object>> packetSubEntryDataList, String entryKey, DynamicObject newEntry, String subEntryKey, int i, int compareTo) throws KdXkIprmException {
        DynamicObjectCollection subentrys = newEntry.getDynamicObjectCollection(subEntryKey);
        subentrys.clear();
        String subEntryEntityName = currentObj.getDynamicObjectType().getName() + "." + entryKey + "." + subEntryKey;
        DynamicObject subEntryProperties = ORM.create().newDynamicObject(subEntryEntityName);
        Map<String, List<String>> subEntrydifferProMap = JsonDynamicConvertHelper.getDifferDynamicProperties(subEntryProperties);
        List<String> subEntryallProList = subEntrydifferProMap.get(ALL_PRO_LIST);
        List<String> subEntrydateList = subEntrydifferProMap.get(DATE_LIST);
        List<String> subEntrydecimalList = subEntrydifferProMap.get(DECIMAL_LIST);
        List<String> subEntrybooleanList = subEntrydifferProMap.get(BOOLEAN_LIST);
        for (Map<String, Object> subEntryData : packetSubEntryDataList) {
            DynamicObject newSubEntry = subentrys.addNew();
            for (Map.Entry<String, Object> entryData : subEntryData.entrySet()) {
                String subEntryFieldKey = entryData.getKey();
                if (!subEntryallProList.contains(subEntryFieldKey)) continue;
                if (subEntrydateList.contains(subEntryFieldKey)) {
                    newSubEntry.set(subEntryFieldKey, (Object)new Date(Long.parseLong(entryData.getValue().toString())));
                    continue;
                }
                if (subEntrydecimalList.contains(subEntryFieldKey)) {
                    newSubEntry.set(subEntryFieldKey, (Object)JsonDynamicConvertHelper.obj2decimal(entryData.getValue()));
                    continue;
                }
                if (subEntrybooleanList.contains(subEntryFieldKey)) {
                    newSubEntry.set(subEntryFieldKey, StringUtils.isEmpty((CharSequence)entryData.getValue().toString()) ? Character.valueOf('0') : entryData.getValue());
                    continue;
                }
                newSubEntry.set(subEntryFieldKey, entryData.getValue());
            }
        }
        if (!packetSubEntryDataList.isEmpty()) {
            JsonDynamicConvertHelper.setSubEntryBdProperties((Map)allData.get(subEntryKey), subentrys, subEntryProperties, i, compareTo);
        }
    }

    private static void setSubEntryBdProperties(Map<String, Object> packetSubBdMap, DynamicObjectCollection subentrys, DynamicObject subEntryProperties, int line, int compareTo) throws KdXkIprmException {
        Map<String, Object> currentBdMap = JsonDynamicConvertHelper.getDynamicBdProperties(subEntryProperties);
        for (Map.Entry<String, Object> propertyMap : packetSubBdMap.entrySet()) {
            String fieldName = propertyMap.getKey();
            Map bdValueMap = (Map)propertyMap.getValue();
            if (!currentBdMap.containsKey(fieldName)) {
                throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5339\u914d\uff0c\u5b50\u5355\u636e\u4f53\u5206\u5f55\u5b57\u6bb5\u201c%1$s\u201d\u5728\u5f53\u524d\u73af\u5883\u7684\u201c%2$s\u201d\u5b9e\u4f53\u4e0a\u4e0d\u5b58\u5728\u3002", (String)"JsonDynamicConvertHelper_3", (String)"imsc-cc", (Object[])new Object[0]), fieldName, subentrys.getRootEntity().getDynamicObjectType().getDisplayName()), 10001);
            }
            String entityName = (String)bdValueMap.get("type");
            String numberField = (String)bdValueMap.get(NUMBER_FIELD);
            JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
            arrays = arrays.getJSONArray(line);
            for (int i = 0; i < subentrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)subentrys.get(i);
                if (arrays.get(i) == null) continue;
                JSONArray value = arrays.getJSONArray(i);
                DynamicObject bd = JsonDynamicConvertHelper.getBdFromFilter(entityName, numberField, value.getString(0), value.getString(1), compareTo);
                if (bd == null) {
                    String displayName = ((BasedataProp)currentBdMap.get(fieldName)).getDisplayName().getLocaleValue();
                    throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\uff08\u7f16\u7801\uff1a%2$s\uff09\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u6570\u636e\u3002", (String)"JsonDynamicConvertHelper_4", (String)"imsc-cc", (Object[])new Object[0]), displayName, entityName, value.getString(1)), 10001);
                }
                entry.set(fieldName, (Object)bd);
            }
        }
    }

    private static void map2Entry(DynamicObject currentObj, Map<String, Object> allData, Map<String, Object> billMap, String key, int compareTo) throws KdXkIprmException {
        DynamicObjectCollection entrys = currentObj.getDynamicObjectCollection(key);
        entrys.clear();
        List packetEntryDataList = (List)billMap.get(key);
        String entryEntityName = currentObj.getDynamicObjectType().getName() + "." + key;
        DynamicObject entryProperties = ORM.create().newDynamicObject(entryEntityName);
        Map<String, List<String>> entrydifferProMap = JsonDynamicConvertHelper.getDifferDynamicProperties(entryProperties);
        List<String> entryallProList = entrydifferProMap.get(ALL_PRO_LIST);
        List<String> entrydateList = entrydifferProMap.get(DATE_LIST);
        List<String> entrydecimalList = entrydifferProMap.get(DECIMAL_LIST);
        List<String> entrybooleanList = entrydifferProMap.get(BOOLEAN_LIST);
        List<String> entryentryList = entrydifferProMap.get(ENTRY_LIST);
        for (int i = 0; i < packetEntryDataList.size(); ++i) {
            Map map = (Map)packetEntryDataList.get(i);
            DynamicObject newEntry = entrys.addNew();
            for (Map.Entry e : map.entrySet()) {
                String entryKey = (String)e.getKey();
                if (!entryallProList.contains(entryKey)) continue;
                if (entrydateList.contains(entryKey)) {
                    newEntry.set(entryKey, (Object)new Date(Long.parseLong(e.getValue().toString())));
                    continue;
                }
                if (entrydecimalList.contains(entryKey)) {
                    newEntry.set(entryKey, (Object)JsonDynamicConvertHelper.obj2decimal(e.getValue()));
                    continue;
                }
                if (entrybooleanList.contains(entryKey)) {
                    newEntry.set(entryKey, (Object)(StringUtils.isEmpty((CharSequence)e.getValue().toString()) ? Character.valueOf('0') : e.getValue()));
                    continue;
                }
                if (entryentryList.contains(entryKey)) {
                    JsonDynamicConvertHelper.map2SubEntry(currentObj, allData, (List)e.getValue(), key, newEntry, entryKey, i, compareTo);
                    continue;
                }
                newEntry.set(entryKey, e.getValue());
            }
        }
        if (!packetEntryDataList.isEmpty()) {
            JsonDynamicConvertHelper.setEntryBdProperties((Map)allData.get(key), entrys, entryProperties, compareTo);
        }
    }

    private static DynamicObject getBdFromFilter(String entityName, String numberField, Object id, String number, int compareTo) {
        QFilter filter = null;
        id = JsonDynamicConvertHelper.idCovert(entityName, id);
        switch (compareTo) {
            case 0: {
                filter = new QFilter("id", "=", id);
                break;
            }
            case 1: {
                filter = new QFilter(numberField, "=", (Object)number);
                break;
            }
            case 2: {
                filter = new QFilter("id", "=", id).or(numberField, "=", (Object)number);
                break;
            }
            default: {
                filter = new QFilter("id", "=", id).and(numberField, "=", (Object)number);
            }
        }
        Map basedatas = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])new QFilter[]{filter});
        if (basedatas == null || basedatas.isEmpty()) {
            return null;
        }
        DynamicObject bd = (DynamicObject)basedatas.get(id);
        if (bd != null) {
            return bd;
        }
        if (basedatas.size() > 0) {
            bd = (DynamicObject)basedatas.values().iterator().next();
        }
        return bd;
    }

    private static Map<String, Object> getDynamicBdProperties(DynamicObject dyObj) {
        HashMap<String, Object> bdMap = new HashMap<String, Object>(8);
        if (dyObj == null) {
            return bdMap;
        }
        DataEntityPropertyCollection proptiesCol = dyObj.getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
            if ((iDataEntityProperty instanceof AssistantProp || !(iDataEntityProperty instanceof BasedataProp)) && !(iDataEntityProperty instanceof MulBasedataProp)) continue;
            bdMap.put(iDataEntityProperty.getName(), iDataEntityProperty);
        }
        return bdMap;
    }

    private static void setEntryBdProperties(Map<String, Object> packetBdMap, DynamicObjectCollection currentObjEntrys, DynamicObject entryProperties, int compareTo) throws KdXkIprmException {
        Map<String, Object> currentBdMap = JsonDynamicConvertHelper.getDynamicBdProperties(entryProperties);
        for (Map.Entry<String, Object> propertyMap : packetBdMap.entrySet()) {
            String fieldName = propertyMap.getKey();
            Map bdValueMap = (Map)propertyMap.getValue();
            if (!currentBdMap.containsKey(fieldName)) {
                throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e0d\u5339\u914d\uff0c\u5206\u5f55\u5b57\u6bb5\u201c%1$s\u201d\u5728\u5f53\u524d\u73af\u5883\u7684%2$s\u5b9e\u4f53\u4e0a\u4e0d\u5b58\u5728\u3002", (String)"JsonDynamicConvertHelper_5", (String)"imsc-cc", (Object[])new Object[0]), fieldName, currentObjEntrys.getRootEntity().getDynamicObjectType().getName()), 10001);
            }
            String entityName = (String)bdValueMap.get("type");
            String numberField = (String)bdValueMap.get(NUMBER_FIELD);
            JSONArray arrays = (JSONArray)JSON.toJSON(bdValueMap.get(CONTENT));
            for (int i = 0; i < currentObjEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)currentObjEntrys.get(i);
                if (arrays.get(i) == null) continue;
                JSONArray value = arrays.getJSONArray(i);
                DynamicObject bd = JsonDynamicConvertHelper.getBdFromFilter(entityName, numberField, value.getString(0), value.getString(1), compareTo);
                if (bd == null) {
                    throw new KdXkIprmException(String.format(ResManager.loadKDString((String)"\u5728\u5f53\u524d\u73af\u5883\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"JsonDynamicConvertHelper_2", (String)"imsc-cc", (Object[])new Object[0]), value.getString(1), ((IDataEntityProperty)currentBdMap.get(fieldName)).getDisplayName()), 10001);
                }
                entry.set(fieldName, (Object)bd);
            }
        }
    }

    public static Object idCovert(String entityName, Object id) {
        if (SCH_JOB.equals(entityName) || SCH_SCHEDULE.equals(entityName) || "bos_entityobject".equals(entityName) || "sch_taskdefine".equals(entityName)) {
            return id;
        }
        try {
            id = Long.parseLong(id.toString());
        }
        catch (NumberFormatException e) {
            return id;
        }
        return id;
    }
}

