/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.json;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.cc.business.install.json.JsonDynamicConvertHelper;
import kd.imsc.cc.business.install.json.JsonInstallingInfoRecord;
import kd.imsc.cc.business.install.json.JsonSheetHandler;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.utils.CommonUtils;
import org.apache.commons.io.FileUtils;

public class JsonImportHelper {
    private static final Log logger = LogFactory.getLog(JsonImportHelper.class);
    private static ThreadLocal<Integer> threadLocal = new ThreadLocal();
    private static final int BATCH_SIZE = 2000;

    private JsonImportHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static JsonInstallingInfoRecord synOnBatchRollbackMode(JSONObject dataMap, String entityName, Set<String> idSet, String keyFields, int compareKey) {
        if (dataMap == null || idSet == null || idSet.isEmpty()) {
            return null;
        }
        int totalSize = idSet.size();
        logger.info("\u5f15\u5165\u5f00\u59cb\uff0c size\uff1a{}" + totalSize);
        threadLocal.set(compareKey);
        JsonInstallingInfoRecord installingInfoRecord = new JsonInstallingInfoRecord();
        try (TXHandle h1 = TX.requiresNew();){
            try {
                installingInfoRecord = JsonImportHelper.batchInstallProcess(dataMap, entityName, idSet, totalSize, keyFields);
                if (!StringUtils.isEmpty((CharSequence)installingInfoRecord.getErrorStr())) {
                    throw new KdXkIprmException(installingInfoRecord.getErrorStr(), 10001);
                }
            }
            catch (Exception e) {
                h1.markRollback();
            }
        }
        threadLocal.remove();
        return installingInfoRecord;
    }

    public static JsonInstallingInfoRecord synOnBatchResumeMode(JSONObject dataMap, String entityName, Set<String> idSet, String keyFields, int compareKey) {
        if (dataMap == null || idSet == null || idSet.isEmpty()) {
            return null;
        }
        int totalSize = idSet.size();
        logger.info("\u5f15\u5165\u5f00\u59cb\uff0c size\uff1a{}" + totalSize);
        threadLocal.set(compareKey);
        JsonInstallingInfoRecord installProcessRecord = JsonImportHelper.batchInstallProcess(dataMap, entityName, idSet, totalSize, keyFields);
        threadLocal.remove();
        return installProcessRecord;
    }

    public static File readJSONDataByModify(File inputFile, JsonSheetHandler sheetHandler) throws IOException {
        if (inputFile == null || !inputFile.exists()) {
            throw new IOException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"JsonImportHelper_0", (String)"imsc-cc", (Object[])new Object[0]));
        }
        File newFile = new File(inputFile.getParentFile().getAbsolutePath() + File.separator + "new_" + inputFile.getName());
        if (newFile.exists()) {
            FileUtils.delete((File)newFile);
        }
        String readStr = FileUtils.readFileToString((File)inputFile, (Charset)StandardCharsets.UTF_8);
        try {
            JSONObject srcObj = JSONObject.parseObject((String)readStr);
            JSONObject modify = sheetHandler.modify(srcObj);
            FileUtils.writeByteArrayToFile((File)newFile, (byte[])modify.toString().getBytes(StandardCharsets.UTF_8));
            return newFile;
        }
        catch (JSONException e) {
            throw new JSONException(ResManager.loadKDString((String)"JSON\u683c\u5f0f\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JsonImportHelper_1", (String)"imsc-cc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static JsonInstallingInfoRecord batchInstallProcess(JSONObject dataMap, String entityName, Set<String> idSet, int totalSize, String keyFields) {
        int i = 0;
        int successCount = 0;
        JsonInstallingInfoRecord installInfoRecord = new JsonInstallingInfoRecord();
        ArrayList<Object> ids = new ArrayList<Object>(2000);
        int batchSize = 2000;
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_accounttype")) {
            batchSize = 1;
        }
        for (String id : idSet) {
            ids.add(JsonDynamicConvertHelper.idCovert(entityName, id));
            if (++i % batchSize != 0 && i != totalSize) continue;
            TXHandle h1 = JsonImportHelper.getImportTransaction();
            Throwable throwable = null;
            try {
                try {
                    logger.info(String.format("\u6279\u6b21%1$s\u5904\u7406\u6210\u529f%2$s\u6761\u6570\u636e\uff01", i, successCount += JsonImportHelper.batchImport(installInfoRecord, entityName, ids, dataMap, keyFields)));
                    ids.clear();
                }
                catch (Exception e) {
                    logger.error("json\u5206\u6279\u5904\u7406\u51fa\u9519", (Throwable)e);
                    h1.markRollback();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h1 == null) continue;
                if (throwable != null) {
                    try {
                        h1.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h1.close();
            }
        }
        if (totalSize != successCount) {
            installInfoRecord.getError().insert(0, String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5904\u7406\u6210\u529f%2$s\u6761\u6570\u636e\uff0c\u9519\u8bef\u539f\u56e0\uff1a", (String)"JsonImportHelper_2", (String)"imsc-cc", (Object[])new Object[0]), totalSize, successCount));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("successCount", successCount);
        param.put("failCount", totalSize - successCount);
        param.put("totalSize", totalSize);
        installInfoRecord.setParam(param);
        logger.info(String.format("\u5171%1$s\u6761\u6570\u636e\uff0c\u5904\u7406\u6210\u529f%2$s\u6761\u6570\u636e\uff01", totalSize, successCount));
        return installInfoRecord;
    }

    private static int batchImport(JsonInstallingInfoRecord installInfoRecord, String entityName, List<Object> ids, JSONObject dataMap, String keyFields) {
        ArrayList<DynamicObject> saveDyList = new ArrayList<DynamicObject>();
        BatchModal batchModal = new BatchModal();
        Map<String, DynamicObject> idsMap = JsonDynamicConvertHelper.loadDyObjToMap(entityName, keyFields, dataMap, ids);
        for (Object id : ids) {
            Map alldata = (Map)dataMap.get(id);
            DynamicObject dyObj = idsMap.get(id.toString());
            if (dyObj != null) {
                batchModal.dynamicObject = dyObj;
                batchModal.op = 2;
            } else {
                batchModal.dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                batchModal.dynamicObject.set("id", id);
                batchModal.op = 1;
            }
            if (!batchModal.isSuccess()) continue;
            try {
                JsonDynamicConvertHelper.map2DynamicObject(batchModal.dynamicObject, batchModal.op, alldata, threadLocal.get());
                JsonDynamicConvertHelper.setBdProperties((Map)alldata.get("bd"), batchModal.dynamicObject, batchModal.op, threadLocal.get());
                JsonDynamicConvertHelper.specialFieldFill(batchModal.dynamicObject);
            }
            catch (KdXkIprmException e) {
                logger.error(" id:{} \u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u672a\u68c0\u67e5\u5230\u7684\u5f02\u5e38\uff1a{} ", id, (Object)CommonUtils.getExceptionDetailInfo(e));
                installInfoRecord.append(String.format(ResManager.loadKDString((String)"%1$s %2$s \u7684\u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u5f02\u5e38\u3002%n", (String)"JsonImportHelper_3", (String)"imsc-cc", (Object[])new Object[0]), batchModal.dynamicObject.getDynamicObjectType().getDisplayName(), entityName), e);
                batchModal.success = 1;
            }
            catch (Exception e) {
                logger.error("id {} \u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u672a\u68c0\u67e5\u5230\u7684\u5f02\u5e38\uff1a{}", id, (Object)CommonUtils.getExceptionDetailInfo(e));
                installInfoRecord.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff08%2$s\uff09\u7684\u5b57\u6bb5\u8d4b\u503c\u51fa\u73b0\u672a\u68c0\u67e5\u5230\u7684\u5f02\u5e38\u3002%n", (String)"JsonImportHelper_4", (String)"imsc-cc", (Object[])new Object[0]), batchModal.dynamicObject.getDynamicObjectType().getDisplayName(), entityName), e);
                batchModal.success = 1;
            }
            if (batchModal.isSuccess()) {
                saveDyList.add(batchModal.dynamicObject);
            }
            batchModal.reset();
        }
        return JsonImportHelper.doBatchSave(installInfoRecord, entityName, saveDyList);
    }

    private static int doBatchSave(JsonInstallingInfoRecord infoRecord, String entityName, List<DynamicObject> saveDy) {
        int success = 0;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("isStrict", "false");
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        try {
            result = SaveServiceHelper.saveOperate((String)entityName, (DynamicObject[])saveDy.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        catch (Exception e) {
            infoRecord.append(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u65f6\u51fa\u73b0\u5f02\u5e38\u3002\u5f02\u5e38\u539f\u56e0\uff1a%1$s\u3002", (String)"JsonImportHelper_5", (String)"imsc-cc", (Object[])new Object[0]), e.getMessage()));
        }
        if (result == null) {
            infoRecord.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"JsonImportHelper_6", (String)"imsc-cc", (Object[])new Object[0]));
            infoRecord.append("\n");
            return 0;
        }
        if (!result.isSuccess()) {
            infoRecord.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"JsonImportHelper_6", (String)"imsc-cc", (Object[])new Object[0])).append(result.getMessage());
            List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
            if (allErrorOrValidateInfo != null) {
                allErrorOrValidateInfo.forEach(x -> infoRecord.getError().append(x.getMessage()));
            }
            infoRecord.append("\n");
            return 0;
        }
        success = result.getSuccessPkIds().size();
        return success;
    }

    private static TXHandle getImportTransaction() {
        Propagation importTransactionType = TX.getPropagation();
        TXHandle txHandle = null;
        switch (importTransactionType) {
            case REQUIRES_NEW: {
                txHandle = TX.requiresNew();
                break;
            }
            case REQUIRED: {
                txHandle = TX.required();
                break;
            }
            case NESTED: {
                txHandle = TX.nested();
                break;
            }
            default: {
                txHandle = TX.notSupported();
            }
        }
        return txHandle;
    }

    public static class BatchModal {
        private DynamicObject dynamicObject;
        private int op;
        private int success = 0;

        public boolean isSuccess() {
            return this.success == 0;
        }

        public void reset() {
            this.dynamicObject = null;
            this.op = 0;
            this.success = 0;
        }
    }
}

