/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;

public class JsonSheetHandler {
    private Map<String, Object> entryMap;

    public JsonSheetHandler(Map<String, Object> entryMap) {
        this.entryMap = entryMap;
    }

    public JSONObject modify(JSONObject srcObj) {
        if (srcObj == null || srcObj.isEmpty()) {
            return srcObj;
        }
        if (this.entryMap == null || this.entryMap.isEmpty()) {
            return srcObj;
        }
        Set keySet = srcObj.keySet();
        String entityType = srcObj.getString("entityType");
        for (String key : keySet) {
            if ("entityType".equals(key)) continue;
            this.modifyData(srcObj.getJSONObject(key), entityType);
        }
        return srcObj;
    }

    private void modifyData(JSONObject dyObj, String entityName) {
        JSONObject bdObj = dyObj.getJSONObject("bd");
        JSONObject dataObj = dyObj.getJSONObject("data");
        Set<Map.Entry<String, Object>> entrySet = this.entryMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            HashMap modifyObj = (HashMap)entry.getValue();
            Object newDataObj = modifyObj.get("new_data");
            if (newDataObj == null || !(newDataObj instanceof DynamicObject)) continue;
            DynamicObject newDyObj = (DynamicObject)newDataObj;
            Object obj = bdObj.get((Object)entry.getKey());
            if (obj instanceof JSONArray) {
                JSONArray bdArray = bdObj.getJSONArray(entry.getKey());
                if (bdArray == null || bdArray.isEmpty()) continue;
                List entryList = bdArray.toJavaList(String.class);
                entryList.remove(entryList.size() - 1);
                entryList.remove(entryList.size() - 1);
                entryList.add(String.valueOf(newDyObj.getPkValue()));
                entryList.add(newDyObj.getString("number"));
                bdObj.put(entry.getKey(), (Object)entryList);
                dataObj.put(entry.getKey() + "_id", (Object)String.valueOf(newDyObj.getPkValue()));
                continue;
            }
            JSONObject jsonObject = bdObj.getJSONObject(entry.getKey());
            if (jsonObject == null) continue;
            JSONArray arrays = (JSONArray)JSON.toJSON((Object)jsonObject.get((Object)"content"));
            for (int i = 0; i < arrays.size(); ++i) {
                JSONArray value = arrays.getJSONArray(i);
                value.clear();
                value.add((Object)String.valueOf(newDyObj.getPkValue()));
                value.add((Object)String.valueOf(newDyObj.getString("number")));
            }
            JSONArray jsonArray = dataObj.getJSONArray(entry.getKey());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                object.put("id", newDyObj.getPkValue());
            }
        }
    }
}

