/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.business.install.json.JsonImportHelper;
import kd.imsc.cc.business.install.json.JsonInstallingInfoRecord;
import kd.imsc.cc.business.install.json.JsonSheetHandler;
import kd.imsc.cc.business.utils.IprmFileUtils;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import org.apache.commons.io.FileUtils;

public class JsonSubPackageHandlerImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(JsonSubPackageHandlerImpl.class);
    private static final String JSON_FORMAT = ".json";

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = super.checkSubDataPackageFile(configInfo);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        logger.info("\u5f00\u59cbJson\u683c\u5f0f\u6570\u636e\u5305 {} \u7279\u5b9a\u68c0\u67e5!", (Object)configInfo.getFileName());
        if (!configInfo.getFileName().endsWith(JSON_FORMAT)) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u5141\u8bb8JSON\u683c\u5f0f\u3002", (String)"JsonSubPackageHandlerImpl_0", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        if (configInfo.getInstallInfo().getCompareKey() < 0) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u672a\u8bf4\u660e\u5bf9\u8c61\u5e8f\u5217\u5316\u65f6\u57fa\u7840\u8d44\u6599\u5982\u4f55\u914d\u7f6e\u3002", (String)"JsonSubPackageHandlerImpl_1", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        checkResult.setSuccess(true);
        return checkResult;
    }

    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo info) {
        String dataStr;
        SubDataInstallResult result = new SubDataInstallResult(configInfo == null ? "" : configInfo.getFileName());
        if (configInfo == null || info == null) {
            result.setError(ResManager.loadKDString((String)"\u5b89\u88c5\u5165\u53c2\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u542f\u52a8\u3002", (String)"JsonSubPackageHandlerImpl_2", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        String keyFields = info.getKeyFields();
        if (StringUtils.isEmpty((String)keyFields)) {
            keyFields = "id";
        }
        if (StringUtils.isEmpty((String)(dataStr = this.readSubDataFromStorage(configInfo)))) {
            result.setError(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%1$s\u201d\u8bfb\u53d6\u5f02\u5e38\u3002", (String)"JsonSubPackageHandlerImpl_3", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return result;
        }
        JSONObject dataObj = null;
        try {
            dataObj = JSON.parseObject((String)dataStr);
        }
        catch (JSONException e) {
            result.setError(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%1$s\u201d\u8f6c\u6362JSON\u5f02\u5e38\u3002", (String)"JsonSubPackageHandlerImpl_4", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return result;
        }
        if (StringUtils.isEmpty((String)dataObj.getString("entityType"))) {
            result.setError(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6587\u4ef6\u201c%1$s\u201d\u4e2d\u7684\u5b9e\u4f53\u7c7b\u578bentityType\uff0c\u6587\u4ef6\u53ef\u80fd\u88ab\u7a9c\u6539\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JsonSubPackageHandlerImpl_5", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return result;
        }
        String entry = dataObj.getString("entityType");
        dataObj.remove((Object)"entityType");
        Set idSet = dataObj.keySet();
        JsonInstallingInfoRecord infoRecord = null;
        infoRecord = configInfo.getSynMode() == 1 ? JsonImportHelper.synOnBatchRollbackMode(dataObj, entry, idSet, keyFields, info.getCompareKey()) : JsonImportHelper.synOnBatchResumeMode(dataObj, entry, idSet, keyFields, info.getCompareKey());
        if (infoRecord == null) {
            result.setError(ResManager.loadKDString((String)"JSON\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"JsonSubPackageHandlerImpl_6", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        if (!infoRecord.isSuccess()) {
            result.setSuccess(false);
            result.setFailed((Integer)infoRecord.getParam().get("failCount"));
            result.setTotal((Integer)infoRecord.getParam().get("totalSize"));
            result.setError(infoRecord.getErrorStr());
            return result;
        }
        result.setTotal((Integer)infoRecord.getParam().get("totalSize"));
        result.setFailed(0);
        return result;
    }

    @Override
    public void subPackageDataModify(SubDataConfigureInfo configInfo, DataPackageModifyResult result) {
        if (configInfo == null || !this.isModifySourceData(result)) {
            return;
        }
        try {
            if (IprmFileUtils.isFileZipFormatWithFileName(configInfo.getFileName())) {
                File xlsxDirectory = new File(new File(configInfo.getFileDirectory()) + File.separator + IprmFileUtils.getFileNameWithOutExtension(configInfo.getFileName()));
                File[] listFiles = xlsxDirectory.listFiles();
                for (int i = 0; i < listFiles.length; ++i) {
                    this.simpleJSONFileModify(result.getReplaceRegMap(), listFiles[i]);
                }
            } else {
                this.simpleJSONFileModify(result.getReplaceRegMap(), new File(new File(configInfo.getFileDirectory()) + File.separator + configInfo.getFileName()));
            }
        }
        catch (IOException e) {
            logger.error("\u6570\u636e\u4fee\u6b63\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return true;
    }

    private String readSubDataFromStorage(SubDataConfigureInfo configInfo) {
        File file = new File(configInfo.getFileDirectory() + File.separator + configInfo.getFileName());
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u540d\u79f0{}\u5f02\u5e38", (Object)file.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    private void simpleJSONFileModify(Map<String, Object> entrySet, File srcFile) throws IOException {
        JsonSheetHandler sheetHandler = new JsonSheetHandler(entrySet);
        File newFile = JsonImportHelper.readJSONDataByModify(srcFile, sheetHandler);
        if (newFile != null && newFile.exists()) {
            String absolutePath = srcFile.getAbsolutePath();
            boolean bakup = srcFile.renameTo(new File(absolutePath + "_bak"));
            boolean delete = newFile.renameTo(new File(absolutePath));
            logger.info("bakUp {} renameTo {}", (Object)bakup, (Object)delete);
        }
    }
}

