/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.microservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.business.install.microservice.MicroServiceHandler;
import kd.imsc.cc.business.install.microservice.MicroServiceParam;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.enums.FileTransferType;
import org.apache.commons.io.FileUtils;

public class MicroSubPackageHandlerImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(MicroSubPackageHandlerImpl.class);
    public static final String IMPORT_PACKET = "importPacket";
    public static final String EXPORT_PACKET = "exportPacket";
    public static final String CLOUD = "cloud";
    public static final String APP_ID = "appid";
    public static final String SERVICE_NAME = "servicename";
    public static final String BATCH_COUNT = "batchcount";
    public static final String PARAMS = "params";
    private final MicroServiceHandler microServiceHandler = new MicroServiceHandler();
    public static final String BYTE_ARR = "byte_arr";

    private String getMicroFail() {
        return ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5206\u6279\u5904\u7406\u6570\u636e\u51fa\u9519\uff0c\u6279\u6b21\u7f16\u53f7\uff1a%s\uff0c\u9519\u8bef\u539f\u56e0\uff1a", (String)"MicroSubPackageHandlerImpl_0", (String)"imsc-cc", (Object[])new Object[0]);
    }

    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo info) {
        Map<String, Object> customParam = configInfo.getDataTransferMap();
        String fileUrl = configInfo.getFileDirectory();
        String fileName = configInfo.getFileName();
        String serviceConfig = configInfo.getPlugin();
        JSONObject obj = JSON.parseObject((String)serviceConfig);
        String fileTransferType = obj.getString("filetransfertype");
        String microCustomParamStr = obj.getString(PARAMS);
        MicroServiceParam microServiceParam = this.getMicroServiceParam(obj, IMPORT_PACKET);
        SubDataInstallResult sdpOutputParams = new SubDataInstallResult();
        sdpOutputParams.setFileName(fileName);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        int totalFileNum = 0;
        int successFileNum = 0;
        HashMap<String, Object> microParamMap = new HashMap<String, Object>(8);
        microParamMap.put("entity_number", info.getFormId());
        microParamMap.put("entity_name", info.getName());
        microParamMap.put("file_transfer_type", fileTransferType);
        microParamMap.put(PARAMS, microCustomParamStr);
        microServiceParam.setParas(microParamMap);
        if (customParam != null) {
            microParamMap.putAll(customParam);
        }
        if (fileName.endsWith(".zip")) {
            File file = new File(configInfo.getFileDirectory() + File.separator + configInfo.getFileName());
            try (FileInputStream inputStream = FileUtils.openInputStream((File)file);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry entry;
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    ++totalFileNum;
                    boolean importSuccess = this.executeMicroImportPacket(fileTransferType, microServiceParam, sdpOutputParams, microParamMap, zipInputStream, entry.getName());
                    if (!importSuccess) continue;
                    ++successFileNum;
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                sdpOutputParams.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38:", (String)"MicroSubPackageHandlerImpl_1", (String)"imsc-cc", (Object[])new Object[0]) + e.getMessage());
                sdpOutputParams.setSuccess(false);
            }
        } else {
            try (InputStream inputStream = fileService.getInputStream(fileUrl);){
                totalFileNum = 1;
                boolean importSuccess = this.executeMicroImportPacket(fileTransferType, microServiceParam, sdpOutputParams, microParamMap, inputStream, fileName);
                if (importSuccess) {
                    successFileNum = 1;
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                sdpOutputParams.append(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u53d1\u751f\u5f02\u5e38:", (String)"MicroSubPackageHandlerImpl_1", (String)"imsc-cc", (Object[])new Object[0]) + e.getMessage());
                sdpOutputParams.setSuccess(false);
            }
        }
        sdpOutputParams.setTotal(totalFileNum);
        sdpOutputParams.setFailed(totalFileNum - successFileNum);
        this.getFileImportTips(sdpOutputParams, totalFileNum, successFileNum);
        logger.info("\u5fae\u670d\u52a1\u5bfc\u5165\u6570\u636e\u5305\u5904\u7406\u5b8c\u6210,\u7ed3\u679c\u4e3a{}", (Object)sdpOutputParams);
        return sdpOutputParams;
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return false;
    }

    public MicroServiceParam getMicroServiceParam(JSONObject obj, String methodName) {
        String cloudNumber = obj.getString(CLOUD);
        String appNumber = obj.getString(APP_ID);
        String serviceName = obj.getString(SERVICE_NAME);
        MicroServiceParam microServiceParam = new MicroServiceParam();
        microServiceParam.setCloudNumber(cloudNumber);
        microServiceParam.setAppNumber(appNumber);
        microServiceParam.setServiceName(serviceName);
        microServiceParam.setMethodName(methodName);
        return microServiceParam;
    }

    private boolean executeMicroImportPacket(String fileTransferType, MicroServiceParam microServiceParam, SubDataInstallResult sdpOutputParams, Map<String, Object> microParamMap, InputStream fileInputStream, String fileName) throws IOException {
        microParamMap.put("file_name", fileName);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Map resultMap;
            kd.imsc.cc.common.utils.FileUtils.inputStreamToOutputStream(fileInputStream, byteArrayOutputStream);
            this.getImportFileParams(fileTransferType, microParamMap, fileName, byteArrayOutputStream);
            try {
                resultMap = (Map)this.microServiceHandler.execute(microServiceParam);
            }
            catch (Exception e) {
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5206\u6279\u5bfc\u5165\u6570\u636e\u51fa\u9519\uff0c\u6279\u6b21\u6587\u4ef6\uff1a%1$s, \u9519\u8bef\u539f\u56e0\uff1a%2$s", (String)"MicroSubPackageHandlerImpl_2", (String)"imsc-cc", (Object[])new Object[0]), fileName, e.getMessage()));
                sdpOutputParams.setSuccess(false);
                boolean bl = false;
                if (byteArrayOutputStream != null) {
                    if (var9_8 != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        byteArrayOutputStream.close();
                    }
                }
                return bl;
            }
            if (this.isRightMicroServiceParams(resultMap, IMPORT_PACKET, fileTransferType, sdpOutputParams)) {
                boolean e = false;
                return e;
            }
            int code = (Integer)resultMap.get("code");
            if (code != 0) {
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\uff1a%1$s, \u6570\u636e\u5904\u7406\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%2$s", (String)"MicroSubPackageHandlerImpl_3", (String)"imsc-cc", (Object[])new Object[0]), fileName, resultMap.get("msg")));
                sdpOutputParams.setSuccess(false);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public void getImportFileParams(String fileTransferType, Map<String, Object> microParamMap, String fileName, ByteArrayOutputStream byteArrayOutputStream) {
        if (FileTransferType.TempFile.getValue().equals(fileTransferType)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempFileUrl = cache.saveAsUrl(fileName, byteArrayOutputStream.toByteArray(), 28800);
            if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
            }
            microParamMap.put("import_url", tempFileUrl);
        } else {
            microParamMap.put(BYTE_ARR, byteArrayOutputStream.toByteArray());
        }
    }

    public boolean isRightMicroServiceParams(Map<String, Object> resultMap, String method, String fileTransferType, SubDataInstallResult sdpOutputParams) {
        if (resultMap == null || resultMap.isEmpty()) {
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002%1$s\u65b9\u6cd5\u9700\u8981\u8fd4\u56demap\u53c2\u6570\u4e3a%2$s", (String)"MicroSubPackageHandlerImpl_4", (String)"imsc-cc", (Object[])new Object[0]), method, EXPORT_PACKET.equals(method) ? ResManager.loadKDString((String)"code,msg,export_url\uff08\u4f20\u8f93\u7c7b\u578b\u4e3a\u4e34\u65f6\u6587\u4ef6\u65f6\uff09\uff0cbyte_arr\uff08\u4f20\u8f93\u7c7b\u578b\u4e3abyte\u6570\u7ec4\u65f6\uff09", (String)"MicroSubPackageHandlerImpl_5", (String)"imsc-cc", (Object[])new Object[0]) : "code,msg"));
            return true;
        }
        if (!resultMap.containsKey("code")) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u8fd4\u56de\u53c2\u6570\u5f02\u5e38\uff0c\u5fc5\u987b\u8fd4\u56decode\uff08\u5fae\u670d\u52a1\u6267\u884c\u72b6\u6001\uff09\u3002", (String)"MicroSubPackageHandlerImpl_6", (String)"imsc-cc", (Object[])new Object[0]));
            return true;
        }
        int code = Integer.parseInt(resultMap.getOrDefault("code", 1).toString());
        if (code != 0 && !resultMap.containsKey("msg")) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5904\u7406\u7684\u6570\u636e\u672a\u6210\u529f\u65f6\uff0c\u5fc5\u987b\u8fd4\u56demsg\uff08\u9519\u8bef\u4fe1\u606f\uff09,\u53ef\u9009\u8fd4\u56dedev_msg\uff08\u5806\u6808\u4fe1\u606f\uff09\u3002", (String)"MicroSubPackageHandlerImpl_7", (String)"imsc-cc", (Object[])new Object[0]));
            return true;
        }
        if (code == 0 && EXPORT_PACKET.equals(method)) {
            return !this.isRightExportMicroServiceParams(resultMap, fileTransferType, sdpOutputParams);
        }
        return false;
    }

    public boolean isRightExportMicroServiceParams(Map<String, Object> resultMap, String fileTransferType, SubDataInstallResult sdpOutputParams) {
        if (FileTransferType.ByteArray.getValue().equals(fileTransferType)) {
            if (!resultMap.containsKey(BYTE_ARR)) {
                sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5fc5\u987b\u8fd4\u56debyte_arr\uff08\u5bfc\u51fa\u7684byte\u6570\u7ec4\uff09\u3002", (String)"MicroSubPackageHandlerImpl_8", (String)"imsc-cc", (Object[])new Object[0]));
                return false;
            }
        } else if (!resultMap.containsKey("export_url")) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5fc5\u987b\u8fd4\u56deexport_url\uff08\u5bfc\u51fa\u7684\u4e34\u65f6\u6587\u4ef6\u5730\u5740\uff09\u3002", (String)"MicroSubPackageHandlerImpl_9", (String)"imsc-cc", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void getFileImportTips(SubDataInstallResult sdpOutputParams, int totalFileNum, int successFileNum) {
        if (successFileNum == totalFileNum) {
            sdpOutputParams.setSuccess(true);
        } else if (successFileNum > 0) {
            sdpOutputParams.getMsg().insert(0, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u4e0d\u6210\u529f\u7684\u6587\u4ef6\uff0c\u603b\u6587\u4ef6\u6570\uff1a%1$s,\u6210\u529f\u6587\u4ef6\u6570\uff1a%2$s", (String)"MicroSubPackageHandlerImpl_10", (String)"imsc-cc", (Object[])new Object[0]), totalFileNum, successFileNum));
            sdpOutputParams.setSuccess(false);
        } else {
            sdpOutputParams.getMsg().insert(0, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5168\u90e8\u5bfc\u5165\u4e0d\u6210\u529f\uff0c\u603b\u6587\u4ef6\u6570\uff1a%s\uff1b", (String)"MicroSubPackageHandlerImpl_11", (String)"imsc-cc", (Object[])new Object[0]), totalFileNum));
            sdpOutputParams.setSuccess(false);
        }
    }
}

