/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.plugin.botp.BOTPFileUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.imsc.cc.business.helper.PermissionHelper;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;

public class BOTPImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(BOTPImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo info) {
        SubDataInstallResult result = new SubDataInstallResult(configInfo.getFileName());
        String fileName = configInfo.getFileDirectory() + File.separator + configInfo.getFileName();
        try (FileInputStream inputStream = new FileInputStream(fileName);){
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)info.getFormId());
            String entityName = entityType.getDisplayName().toString();
            Tuple<Boolean, String> checkPermissionTuple = PermissionHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), entityType.getAppId(), info.getFormId(), entityName, "47150e89000000ac", "47156aff000000ac", "4715a0df000000ac");
            boolean hashPermissions = (Boolean)checkPermissionTuple.item1;
            if (!hashPermissions) {
                result.setError((String)checkPermissionTuple.item2);
                SubDataInstallResult subDataInstallResult = result;
                return subDataInstallResult;
            }
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempFileUrl = cache.saveAsUrl(configInfo.getFileName(), (InputStream)inputStream, 18000);
            if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
            }
            BOTPFileUtil fileUtil = new BOTPFileUtil("cr");
            JSONObject importResult = new JSONObject();
            importResult.put("ERROR", (Object)"");
            boolean success = fileUtil.uploadRule(tempFileUrl, importResult);
            if (!success) {
                result.setSuccess(false);
                result.setTotal(1);
                result.setFailed(1);
                result.append(importResult.get((Object)"ERROR").toString());
                result.append("\n");
            } else {
                result.setSuccess(true);
                result.setTotal(1);
                result.setFailed(0);
            }
            SubDataInstallResult subDataInstallResult = result;
            return subDataInstallResult;
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s\u3002", (String)"BOTPImpl_0", (String)"imsc-cc", (Object[])new Object[0]), info.getFormId(), e.getMessage());
            logger.error(errorMsg, (Throwable)e);
            result.setTotal(1);
            result.setFailed(1);
            result.setError(errorMsg);
            return result;
        }
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return false;
    }
}

