/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.business.install.plugin.FilterSchemeHelper;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import org.apache.commons.io.FileUtils;

public class FilterSchemeImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(FilterSchemeImpl.class);
    private static final String FORMAT = ".json";
    private static final String ROUTE_KEY = "routKey";
    private static final String MAIN_DATA = "mainData";
    private static final String MULTI_TEXT = "multiText";

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = super.checkSubDataPackageFile(configInfo);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        logger.info("\u5f00\u59cb\u8fc7\u6ee4\u65b9\u6848\u6570\u636e\u5305 {} \u7684\u7279\u5b9a\u68c0\u67e5!", (Object)configInfo.getFileName());
        if (!configInfo.getFileName().endsWith(FORMAT)) {
            checkResult.setFail(String.format(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u53ea\u5141\u8bb8JSON\u683c\u5f0f\u3002", (String)"FilterSchemeImpl_0", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return checkResult;
        }
        checkResult.setSuccess(true);
        return checkResult;
    }

    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo info) {
        JSONObject dataObj;
        SubDataInstallResult result = new SubDataInstallResult(configInfo == null ? "" : configInfo.getFileName());
        if (configInfo == null || info == null) {
            result.setError(ResManager.loadKDString((String)"\u542f\u52a8\u5b89\u88c5\u5165\u53c2\u5f02\u5e38", (String)"FilterSchemeImpl_1", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        String dataStr = this.readSubDataFromStorage(new File(configInfo.getFileDirectory() + File.separator + configInfo.getFileName()));
        if (StringUtils.isEmpty((String)dataStr)) {
            result.setError(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6587\u4ef6\u201c%1$s\u201d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"FilterSchemeImpl_2", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return result;
        }
        try {
            dataObj = JSON.parseObject((String)dataStr);
        }
        catch (JSONException e) {
            result.setError(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u3010%1$s\u3011\u8f6c\u6362JSON\u5f02\u5e38", (String)"FilterSchemeImpl_3", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return result;
        }
        if (dataObj == null || dataObj.isEmpty()) {
            result.setError(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u3010%1$s\u3011\u8f6c\u6362JSON\u5f02\u5e38", (String)"FilterSchemeImpl_3", (String)"imsc-cc", (Object[])new Object[0]), configInfo.getFileName()));
            return result;
        }
        String routeKey = dataObj.getString(ROUTE_KEY);
        JSONObject mainDataObj = dataObj.getJSONObject(MAIN_DATA);
        JSONObject multiTextObj = dataObj.getJSONObject(MULTI_TEXT);
        return FilterSchemeHelper.filterSchemeImport(configInfo.getFileName(), routeKey, mainDataObj, multiTextObj);
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return false;
    }

    private String readSubDataFromStorage(File file) {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u540d\u79f0{}\u5f02\u5e38", (Object)file.getAbsolutePath(), (Object)e);
            return null;
        }
    }
}

