/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.utils.CommonUtils;

public class VchtemplateImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(VchtemplateImpl.class);
    private static final String ORG = "org";
    private static final String ORG_NUMBER = "org_number";

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = super.checkSubDataPackageFile(configInfo);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        logger.info("\u5f00\u59cb\u51ed\u8bc1\u6a21\u677f\u6570\u636e\u5305 {} \u7279\u5b9a\u68c0\u67e5!", (Object)configInfo.getFileName());
        checkResult.setSuccess(true);
        return checkResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo info) {
        SubDataInstallResult result = new SubDataInstallResult(configInfo.getFileName());
        result.setSuccess(false);
        Map<String, Object> dataTransferMap = configInfo.getDataTransferMap();
        if (dataTransferMap == null || dataTransferMap.isEmpty()) {
            result.setTotal(1);
            result.setFailed(1);
            result.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u4fee\u6539\u610f\u89c1\uff1a\u8bf7\u586b\u5199\u201c\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"VchtemplateImpl_0", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        Object org = dataTransferMap.get(ORG);
        if (org == null) {
            result.setTotal(1);
            result.setFailed(1);
            result.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u83b7\u53d6\u201c\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7\u201d\u5931\u8d25\u3002", (String)"VchtemplateImpl_1", (String)"imsc-cc", (Object[])new Object[0]));
            return result;
        }
        Long orgId = Long.parseLong(org.toString());
        String fileName = configInfo.getFileDirectory() + File.separator + configInfo.getFileName();
        try (FileInputStream inputStream = new FileInputStream(fileName);){
            String fileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(configInfo.getFileName(), (InputStream)inputStream, 18000);
            String importResultStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"VchTemplateOperateService", (String)"importVchTemplate", (Object[])new Object[]{fileUrl, orgId});
            logger.info("\u51ed\u8bc1\u6a21\u677f\u5bfc\u5165|\u7ed3\u679c|{}", (Object)importResultStr);
            JSONObject importResult = JSON.parseObject((String)importResultStr);
            if (null == importResult || null == importResult.get((Object)"success")) {
                result.setTotal(1);
                result.setFailed(1);
                result.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u6ca1\u6709\u83b7\u53d6\u5230\u5bfc\u5165\u7ed3\u679c\u3002", (String)"VchtemplateImpl_2", (String)"imsc-cc", (Object[])new Object[0]));
                SubDataInstallResult subDataInstallResult = result;
                return subDataInstallResult;
            }
            if (importResult.getBoolean("success").booleanValue()) {
                result.setSuccess(true);
                result.setTotal(1);
                result.setFailed(0);
                return result;
            }
            result.append(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\uff0c%s", (String)"VchtemplateImpl_3", (String)"imsc-cc", (Object[])new Object[0]), importResult.get((Object)"reason") == null ? "" : importResult.getString("reason")));
            result.setTotal(1);
            result.setFailed(1);
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            result.append(CommonUtils.getExceptionDetailInfo(e));
            result.setTotal(1);
            result.setFailed(1);
        }
        return result;
    }

    @Override
    public void subPackageDataModify(SubDataConfigureInfo configInfo, DataPackageModifyResult result) {
        if (!this.isModifySourceData(result)) {
            return;
        }
        Object orgObj = result.getReplaceRegMap().get(ORG);
        if (orgObj == null) {
            return;
        }
        HashMap orgMap = (HashMap)orgObj;
        Object dataValue = orgMap.get("new_data");
        if (dataValue == null) {
            return;
        }
        DynamicObject newObj = (DynamicObject)dataValue;
        HashMap<String, Object> transFormMap = new HashMap<String, Object>();
        transFormMap.put(ORG, newObj.getPkValue());
        transFormMap.put(ORG_NUMBER, newObj.get("number"));
        configInfo.setDataTransferMap(transFormMap);
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return false;
    }
}

