/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.imsc.cc.business.install.AbstractSubPackageHandler;
import kd.imsc.cc.business.install.plugin.WFModelHelper;
import kd.imsc.cc.business.utils.IprmFileUtils;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import kd.imsc.cc.common.entity.SubDataCheckResult;
import kd.imsc.cc.common.entity.SubDataConfigureInfo;
import kd.imsc.cc.common.entity.SubDataInstallInfo;
import kd.imsc.cc.common.entity.SubDataInstallResult;

public class WFModelImpl
extends AbstractSubPackageHandler {
    private static final Log logger = LogFactory.getLog(WFModelImpl.class);
    private DcxmlSerializer serializer = new DcxmlSerializer(DeployModel.getDCBinder());
    private static final String WFMODEL_NUMBER = "key";
    private static final String PROCESS = ".process";

    @Override
    public SubDataCheckResult checkSubDataPackageFile(SubDataConfigureInfo configInfo) {
        SubDataCheckResult checkResult = super.checkSubDataPackageFile(configInfo);
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        logger.info("\u5f00\u59cb\u51ed\u8bc1\u6a21\u677f\u6570\u636e\u5305 {} \u7279\u5b9a\u68c0\u67e5!", (Object)configInfo.getFileName());
        if (!IprmFileUtils.isFileZipFormatWithFileName(configInfo.getFileName())) {
            checkResult.setFail(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u5141\u8bb8zip\u683c\u5f0f\u3002", (String)"WFModelImpl_0", (String)"imsc-cc", (Object[])new Object[0]));
            return checkResult;
        }
        File dataPackageDirectory = new File(configInfo.getFileDirectory() + File.separator + IprmFileUtils.getFileNameWithOutExtension(configInfo.getFileName()));
        File[] dataFiles = dataPackageDirectory.listFiles();
        if (dataFiles == null || dataFiles.length == 0) {
            checkResult.setFail(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u5141\u8bb8process\u683c\u5f0f\u3002", (String)"WFModelImpl_1", (String)"imsc-cc", (Object[])new Object[0]));
            return checkResult;
        }
        for (int i = 0; i < dataFiles.length; ++i) {
            File dataFile = dataFiles[i];
            if (dataFile.getName().endsWith(PROCESS)) continue;
            checkResult.setFail(ResManager.loadKDString((String)"\u5b50\u6570\u636e\u5305\u201c%1$s\u201d\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff0c\u53ea\u5141\u8bb8process\u683c\u5f0f\u3002", (String)"WFModelImpl_1", (String)"imsc-cc", (Object[])new Object[0]));
            return checkResult;
        }
        checkResult.setSuccess(true);
        return checkResult;
    }

    @Override
    public SubDataInstallResult installPacket(SubDataConfigureInfo configInfo, SubDataInstallInfo info) {
        SubDataInstallResult result = new SubDataInstallResult(configInfo.getFileName());
        HashMap<String, String> procFileMap = new HashMap<String, String>(8);
        int successCount = 0;
        int total = 0;
        String zipPath = configInfo.getFileDirectory() + File.separator + configInfo.getFileName();
        try (FileInputStream inputStream = new FileInputStream(zipPath);
             ZipInputStream zipIn = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), Charset.forName("GBK"));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                ++total;
                String fileName = zipEntry.getName();
                String content = WFModelHelper.getZipFileContent(zipIn);
                String errMsg = this.checkAndDeployModel(configInfo.getFileName(), procFileMap, fileName, content);
                if (!StringUtils.isEmpty((String)errMsg)) {
                    result.append(errMsg);
                    continue;
                }
                ++successCount;
            }
        }
        catch (IOException e) {
            result.setSuccess(false);
            result.setTotal(total);
            result.setFailed(total - successCount);
            result.append(e.getMessage());
            return result;
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setTotal(total);
            result.setFailed(total - successCount);
            result.append(e.getMessage());
            return result;
        }
        if (successCount == total) {
            result.setSuccess(true);
            result.setTotal(total);
            result.setFailed(0);
            return result;
        }
        result.setTotal(total);
        result.setFailed(total - successCount);
        result.setSuccess(false);
        return result;
    }

    @Override
    public void subPackageDataModify(SubDataConfigureInfo configInfo, DataPackageModifyResult result) {
    }

    @Override
    public boolean isZipFileNeedUnzip() {
        return true;
    }

    private String checkAndDeployModel(String zipFileName, Map<String, String> procFileMap, String fileName, String content) {
        if (StringUtils.isEmpty((String)content)) {
            String msgTpl = ResManager.loadKDString((String)"%1$s\u4e2d\u7684%2$s \u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"WFModelImpl_2", (String)"imsc-cc", (Object[])new Object[0]);
            return String.format(msgTpl, zipFileName, fileName);
        }
        this.serializer.setColloctionIgnorePKValue(true);
        Object dModel = WFModelHelper.dModel(this.serializer, content);
        if (dModel == null || !(dModel instanceof DeployModel)) {
            String msgTpl = ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u201c%s\u201d\u51fa\u9519\u3002\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u4e3a\u6709\u6548\u7684 process \u6587\u4ef6\u3002", (String)"WFModelImpl_3", (String)"imsc-cc", (Object[])new Object[0]);
            return String.format(msgTpl, fileName);
        }
        DeployModel deployModel = (DeployModel)dModel;
        List models = deployModel.getModels();
        if (models == null || models.isEmpty()) {
            String msgTpl = ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u201c%s\u201d\u51fa\u9519\u3002\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u4e3a\u6709\u6548\u7684 process \u6587\u4ef6\u3002", (String)"WFModelImpl_3", (String)"imsc-cc", (Object[])new Object[0]);
            return String.format(msgTpl, fileName);
        }
        DynamicObject model = (DynamicObject)models.get(0);
        String wfModelNumber = model.getString(WFMODEL_NUMBER);
        String entraBill = model.getString("entrabill");
        String procFile = procFileMap.get(wfModelNumber);
        if (procFile != null) {
            return String.format(ResManager.loadKDString((String)"%1$s \u4e0e %2$s\u4e2d\u7684%3$s\u6587\u4ef6\u4e2d\u7684\u6d41\u7a0b\u91cd\u590d\u3002", (String)"WFModelImpl_4", (String)"imsc-cc", (Object[])new Object[0]), procFile, zipFileName, fileName);
        }
        procFileMap.put(wfModelNumber, String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684%2$s\u6587\u4ef6", (String)"WFModelImpl_5", (String)"imsc-cc", (Object[])new Object[0]), zipFileName, fileName));
        if (!QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entraBill)})) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"WFModelImpl_6", (String)"imsc-cc", (Object[])new Object[0]), entraBill);
        }
        QFilter[] filters = new QFilter[]{new QFilter(WFMODEL_NUMBER, "=", (Object)wfModelNumber), new QFilter("entrabill", "!=", (Object)entraBill)};
        if (QueryServiceHelper.exists((String)"wf_model", (QFilter[])filters)) {
            return String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u7f16\u7801\u4e3a %s \u7684\u5176\u4ed6\u5355\u636e\u6d41\u7a0b\uff0c\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"WFModelImpl_7", (String)"imsc-cc", (Object[])new Object[0]), wfModelNumber);
        }
        ImportExportProcessUtil.checkProcessTypeConsistent((String)wfModelNumber, (String)model.getString("type"), (boolean)false);
        QFilter[] qFilters = new QFilter[]{new QFilter(WFMODEL_NUMBER, "=", (Object)wfModelNumber)};
        boolean isCover = QueryServiceHelper.exists((String)"wf_model", (QFilter[])qFilters);
        boolean isCoverSummaryCfg = true;
        this.getRepositoryService().deployModel(deployModel, isCover, Boolean.valueOf(isCoverSummaryCfg));
        WfUtils.addLog((String)"wf_model", (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6d41\u7a0b", (String)"WFModelImpl_8", (String)"imsc-cc", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u6d41\u7a0bID\uff1a%1$s\uff0c\u7f16\u7801\uff1a%2$s\u3002", (String)"WFModelImpl_9", (String)"imsc-cc", (Object[])new Object[0]), model.getPkValue().toString(), wfModelNumber));
        return null;
    }

    public RepositoryService getRepositoryService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
    }
}

