/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.iprm.gcpapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.MultiLangEnumBridge;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.imsc.cc.business.iprm.gcpapi.GcpDigestApiBuilder;
import kd.imsc.cc.business.iprm.gcpapi.PermissionHelper;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.constants.iprm.model.GcpApiType;

public abstract class AbstractGcpBridgeManager<T> {
    private static final Log logger = LogFactory.getLog(AbstractGcpBridgeManager.class);
    public String LIC_PORDID = "2D3=SA5XL/93";

    public abstract BizOperationResult baseGcpRequestByGet(Map<String, Object> var1, T var2);

    public abstract BizOperationResult baseGcpRequestByPostJson(Map<String, Object> var1, T var2);

    public Map<String, String> baseReqParams() {
        List productInfos;
        String isv;
        String starryVersion;
        HashMap<String, String> baseMap = new HashMap<String, String>(6);
        String kdVersion = PermissionHelper.getKdCosmicVersion();
        if (!StringUtils.isEmpty((String)kdVersion)) {
            baseMap.put("cosmic_version", kdVersion);
        }
        if (!StringUtils.isEmpty((String)(starryVersion = PermissionHelper.getKdStarryVersion()))) {
            baseMap.put("starry_version", starryVersion);
        }
        try {
            baseMap.put("r_uname", URLEncoder.encode(RequestContext.get().getUserName(), "UTF-8"));
            String domain = System.getProperty("domain.contextUrl");
            if (!StringUtils.isEmpty((String)domain)) {
                baseMap.put("r_domain", URLEncoder.encode(new URL(domain).getHost(), "UTF-8"));
            }
        }
        catch (Exception domain) {
            // empty catch block
        }
        baseMap.put("r_uid", String.valueOf(RequestContext.get().getCurrUserId()));
        baseMap.put("lang", RequestContext.get().getLang().name());
        baseMap.put("tenant", RequestContext.get().getTenantCode());
        baseMap.put("tenant_id", RequestContext.get().getTenantId());
        if (RequestContext.get().getTenantInfo() != null && !StringUtils.isEmpty((String)RequestContext.get().getTenantInfo().getName())) {
            baseMap.put("tenant_name", RequestContext.get().getTenantInfo().getName());
        }
        if (!StringUtils.isEmpty((String)RequestContext.get().getAccountId())) {
            baseMap.put("acc_id", RequestContext.get().getAccountId());
        }
        if (!StringUtils.isEmpty((String)(isv = PermissionHelper.getIsv()))) {
            baseMap.put("isv", isv);
        }
        if (CollectionUtils.isNotEmpty((Collection)(productInfos = LicenseServiceHelper.getProductInfos()))) {
            for (Map prodInfo : productInfos) {
                if (this.LIC_PORDID.equals(prodInfo.get("prodid")) && StringUtils.isNotEmpty((String)((String)prodInfo.get("prodInstCode")))) {
                    baseMap.put("rProd", (String)prodInfo.get("prodInstCode"));
                }
                if (!StringUtils.isNotEmpty((String)((String)prodInfo.get("softwareCode")))) continue;
                baseMap.put("softwarecode", (String)prodInfo.get("softwareCode"));
            }
        }
        return baseMap;
    }

    public String recordTenantInfo() {
        BizOperationResult result = new BizOperationResult(false);
        try {
            GcpDigestApiBuilder gcpDigestApiBuilder = GcpDigestApiBuilder.getGcpDigestApiBuilder();
            String url = gcpDigestApiBuilder.getFullUrl(new GcpApiType(new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e0a\u4f20\u79df\u6237\u4fe1\u606f", (String)"AbstractGcpBridgeManager_0", (String)"bos-ext-imsc-business", (Object[])new Object[0]), "TypeEnum_16", "imsc-iprm-business", new Object[0]), "/kapi/v2/rgc/rgc_base/recordTenant"));
            HashMap<String, String> params = new HashMap<String, String>();
            params.putAll(this.baseReqParams());
            String resultPost = HttpClientUtils.postAppJson((String)url, null, params);
            this.parseHttpResp(resultPost, result, url);
        }
        catch (Exception ex) {
            logger.error("recordTenantInfo()\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff1a", (Throwable)ex);
            result.setErrorCode(99);
            result.setErrorDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"AbstractGcpBridgeManager_1", (String)"bos-ext-imsc-business", (Object[])new Object[0]), ex.getMessage()));
        }
        if (!result.getSuccess() || result.getData() == null) {
            return "";
        }
        return String.valueOf(result.getData());
    }

    public void parseHttpResp(String resultPost, BizOperationResult result, String url) {
        if (StringUtils.isNotEmpty((String)resultPost)) {
            JSONObject returnMap = JSON.parseObject((String)resultPost);
            String code = returnMap.getOrDefault((Object)"errorCode", (Object)"000").toString();
            logger.info("GCP Response {}", (Object)code);
            if (code.equals("0")) {
                result.setSuccess(true);
                result.setData(returnMap.get((Object)"data"));
            } else {
                result.setErrorCode(!StringUtils.isNumberString((String)code) ? 101 : Integer.parseInt(code));
                Object message = returnMap.getOrDefault((Object)"message", (Object)"");
                if (message != null && StringUtils.isBlank((String)message.toString())) {
                    message = url;
                }
                result.setErrorDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff1a%s", (String)"AbstractGcpBridgeManager_2", (String)"bos-ext-imsc-business", (Object[])new Object[0]), message));
            }
        }
    }
}

